'use strict';

angular.module('wallpapersApp', ['ngResource', 'ngMobile', 'infinite-scroll'])
    .factory('myHttpInterceptor', ['$q', '$rootScope', function ($q, $rootScope) {
        return function (promise) {
            return promise.then(function (response) {
                $rootScope.setLoading(false);
                return response;
            }, function (response) {
                $rootScope.setLoading(false);
                console.log(response.status);
                // do something on error
                return $q.reject(response);
            });
        };
    }])
    .config(['$routeProvider', '$httpProvider', function ($routeProvider, $httpProvider) {
        $routeProvider
            .when('/', {
                templateUrl: 'views/items.html',
                controller: 'Main'
            })
            .when('/best', {
                templateUrl: 'views/items.html',
                controller: 'Best'
            })
            .when('/categories', {
                templateUrl: 'views/categories.html',
                controller: 'Categories'
            })
            .when('/help', {
                templateUrl: 'views/help.html',
                controller: 'Help'
            })
            .when('/preview', {
                templateUrl: 'views/preview.html',
                controller: 'Preview'
            })
            .when('/category/:cat_id/:name', {
                templateUrl: 'views/items.html',
                controller: 'Category'
            })
            .otherwise({
                redirectTo: '/'
            });

        /**
         * handle global response
         */
        $httpProvider.responseInterceptors.push('myHttpInterceptor');
    }])
    .factory('Config', function() {
        return {
            url: "http://floating-peak-3642.herokuapp.com/"
        };
    })
    .factory('Storage', function() {
        return Storage;
    })
    .run(['$rootScope', '$window', '$location', function($scope, $window, $location) {

        /**
         * Flag for application not bought
         * @type {boolean}
         */
        $scope.lock = true;

        /**
         * Loading flag
         * @type {boolean}
         */
        $scope.loading = false;

        /**
         * Show/hide menu
         * @type {boolean}
         */
        $scope.menuShow = false;

        /**
         * Header title
         *
         * @type {string}
         */
        $scope.header = 'Graffito';

        /**
         * Device online/offline flag
         * @type {boolean}
         */
        $scope.online = navigator.onLine || false;

        /**
         * List of locations
         *
         * @type {Array}
         */
        $scope.locations = [];

        /**
         *
         * @type {{}}
         */
        $scope.defaults = {};

        /**
         * Unlock application
         */
        $scope.unlock = function() {
            $scope.lock = false;
            $scope.$broadcast('unlocked', {});
        };

        $window.addEventListener('online', function() {
            $scope.online = true;
            if (!$scope.$$phase) {
                $scope.$digest();
            }
        });

        $window.addEventListener('offline', function() {
            $scope.online = false;
            if (!$scope.$$phase) {
                $scope.$digest();
            }
        });

        /**
         * Set loading val
         */
        $scope.setLoading = function(loading) {
            $scope.loading = loading;
        };

        /**
         * Show/hide menu
         * @param {boolean} show
         */
        $scope.showMenu = function(show) {
            $scope.menuShow = show;
        };

        /**
         * Set header
         * @param header
         */
        $scope.setHeader = function(header) {
            $scope.header = header;
        };

        /**
         * Navigate from menu
         */
        $scope.navigate = function(url) {
            $scope.showMenu(false);
            /**
             * we shouldn't navigate to self
             */
            if (url == $location.path()) {
                return;
            }
            $scope.locations.push(url);
            $location.path(url).replace();
        };

        /**
         * Navigate back
         */
        $scope.back = function() {
            $scope.showMenu(false);
            if ($scope.locations.length > 0) {
                var url = $scope.locations.pop();
                if (url === '/preview' || url === $location.path()) {
                    $scope.back();
                    return;
                }
                $scope.navigate(url);
            } else {
                $location.path("/").replace();
            }
        };

        /**
         * Mock function for refresh button.
         *
         * Overwrite it when you need
         */
        $scope.refresh = function() {
            $scope.$broadcast('refresh', {url: $location.path()});
        };

        /**
         * Update something when location changes
         */
        $scope.$on('$locationChangeStart', function() {
            $scope.defaults = {};
        });

        /**
         * Verify applpication
         * @type {mozmarket.receipts.Verifier}
         */
        var verifier = new mozmarket.receipts.Verifier({
//            typsAllowed: ['purchase-receipt', 'developer-receipt', 'reviewer-receipt', 'test-receipt']
        });
        verifier.verify(function (verifier) {
            // Look at verifier.state to see how it went
            if (verifier.state instanceof verifier.states.NeedsInstall) {
                alert("You must install this app from Marketplace");
                return;
            }
            if (verifier.state instanceof verifier.states.NetworkError) {
                // it was some kind of network or server error
                // i.e., not the fault of the user
                // you may want to let the user in, but for a limited time
                alert('You have to be online to verify application.');
            } else if (verifier.state instanceof verifier.states.InternalError) {
                // The verifier library itself got messed up; this shouldn't happen!
                // It's up to you if you want to reject the user at this point
                alert('Something wrong with application verification. Sorry, try to reload application.');
            } else if (verifier.state instanceof verifier.states.OK) {
                // Everything is cool
                $scope.$apply(function(sc) {
                    sc.unlock();
                });
            } else {
                // Some other error occurred; maybe it was never a valid receipt, maybe
                // the receipt is corrupted, or someone is trying to mess around.
                // It would not be a bad idea to log this.
                alert("Your purchase is invalid; please purchase again, or reinstall from the Marketplace.");
            }
        });
    }]);
