'use strict';

var Storage = {

    _storage: navigator.getDeviceStorage('pictures'),

    _isAvail: false,

    init: function() {
        this._storage.available().onsuccess = (function(e) {
            this.updateStorageState(e.target.result);
        }.bind(this));
    },

    /**
     * Update current avail state
     *
     * @param state
     */
    updateStorageState: function(state) {
        switch(state) {
            case 'available':
                this._isAvail = true;
                break;
            default:
                this._isAvail = false;
                break;
        }
    },

    store: function(data, filename) {
        if (!this._isAvail) {
            var notification = navigator.mozNotification.createNotification(
                "Download failed", "Please insert sdcard.");

            notification.show();
            return;
        }
        var store = this._storage.addNamed(data, 'graffito/'+Date.now()+filename);
        store.onerror = function(err) {
            console.log(store.error);
            var notification = navigator.mozNotification.createNotification(
                "Download failed", "Sorry image couldn't be downloaded.");

            notification.show();
        };

        store.onsuccess = function(filename) {
            console.log(filename);
            var notification = navigator.mozNotification.createNotification(
                "Download finished", "Image successfully downloaded to your library.");

            notification.show();
        };
    }
};