function getCover() {
    var artist = document.getElementById("artist").innerHTML;
    var album  = document.getElementById("album").innerHTML;

    var artistPhoto = document.querySelector(".artist-photo");
    var albumCover  = document.querySelector(".album-cover");

    // No cover
    if (settings.display_cover == 0) {
        albumCover.hidden = true;
        artistPhoto.hidden = true;
        return;
    }

    // Album cover
    if (settings.display_cover == 1) {

        // Hide artist photo
        artistPhoto.hidden = true;

        // Fetch album cover only if not the same
        if ( (albumCover.getAttribute('data-artist') != artist) || (albumCover.getAttribute('data-artist') != album) ) {
            $.getJSON("http://ws.audioscrobbler.com/2.0/?method=album.getinfo&api_key=7facb82a2a573dd483d931044030e30c&artist=" + artist + "&album=" + album + "&format=json", function(data) {

                var cover_url;

                $.each(data.album.image, function(i,item){
                    if (item.size == 'mega'){
                        cover_url = item['#text'];
                    }
                });

                if (cover_url) {
                    if (!albumCover.getAttribute('src').contains(cover_url)) {
                        albumCover.setAttribute('src', cover_url);
                        albumCover.setAttribute('data-artist', artist);
                        albumCover.setAttribute('data-album', album);
                    }
                    albumCover.hidden = false;
                } else {
                    albumCover.hidden = true;
                }

            });
        } else {
            albumCover.hidden = false;
        }

        return;
    }

    // Artist photo
    if (settings.display_cover == 2) {

        // Hide album cover
        albumCover.hidden = true;

        // Fetch artist photo
        if (artistPhoto.getAttribute('data-artist') != artist) {
            $.getJSON("http://ws.audioscrobbler.com/2.0/?method=artist.getinfo&api_key=7facb82a2a573dd483d931044030e30c&artist=" + artist + "&format=json", function(data) {

                var cover_url;

                $.each(data.artist.image, function(i,item){
                    if (item.size == 'mega'){
                        cover_url = item['#text'];
                    }
                });

                if (cover_url) {
                    if (!artistPhoto.style.background.contains(cover_url)) {
                        artistPhoto.style.background = "url(" + cover_url + ") top center no-repeat";
                        artistPhoto.setAttribute('data-artist', artist);
                    }
                    artistPhoto.hidden = false;
                } else {
                    artistPhoto.hidden = true;
                }

            });
        } else {
            artistPhoto.hidden = false;
        }

        return;
    }

}
