// DB
var database = {
    version : 1,
    db      : null,

    DB_STORE_SETTINGS : 'settings',

    initialize: function() {
        // Let us open our database
        console.log('db.initialize');
        //window.indexedDB.deleteDatabase("FeedsDB"); // ! Delete database
        var request = window.indexedDB.open("SimpleMPCDB", this.version);

        // Responses request
        request.onerror = function(event) {
            // Do something with request.errorCode!
            console.error('DB open error');
        };

        var self = this;
        request.onsuccess = function(event) {
            console.log('DB open success');
            self.db = request.result;

            console.log('   db version : ' + self.db.version);

            database.loadSettings();

            self.db.onerror = function(event) {
                // Generic error handler for all errors targeted at this database's
                // requests!
                console.error("Database error: " + event.target.errorCode);
            };
        };

        // UPGRADE
        request.onupgradeneeded = function(event) {
            var db = event.target.result;

            console.log('onupgradeneeded : ' + db.version);

            if (db.version == 1)
            {
                console.log('   create object stores...');
                db.createObjectStore(database.DB_STORE_SETTINGS);
                console.log('   ... done');
            }
        };
    },

    // Get object store
    getObjectStore: function (store_name, mode) {
        //console.log('getObjectStore : ' + store_name + ' - ' + mode);
        var transaction = database.db.transaction(store_name, mode);

        transaction.oncomplete = function(event) {};

        transaction.onerror = function(event) {
            // Don't forget to handle errors!
            console.error("transaction.error");
            return null;
        };

        return transaction.objectStore(store_name);
    },

    // Settings
    loadSettings: function() {
        console.log('loadSettings');
        var settingsStore = this.getObjectStore(database.DB_STORE_SETTINGS, 'readonly');

        settingsStore.openCursor().onsuccess = function(event)
        {
            var cursor = event.target.result;

            if (cursor)
            {
                console.log('loadSettings : ' + cursor.value.host);
                settings.initialize(cursor.value);
                cursor.continue();
            }
            else
            {
                console.log("Got all settings");
            }
        };

        settingsStore.openCursor().onerror = function(event) {
            console.error('loadSettings.onerror');
        };
    },

    saveSettings: function (values) {
        console.log('saveSettings');
        var settingsStore = this.getObjectStore(database.DB_STORE_SETTINGS, 'readwrite');

        //console.log('save : ' + values);
        var request = settingsStore.put(values, database.DB_STORE_SETTINGS);
        request.onsuccess = function(event) {
            console.log('settings saved :' + values);
        };
    }
};

database.initialize();
