var PlaybackView = Backbone.View.extend({
    el: 'section#home-view',
    events: {
        'click  #play'     : 'play',
        'click  #pause'    : 'pause',
        'click  #previous' : 'previous',
        'click  #next'     : 'next'
    },

    initialize: function(){
        console.log('PlaybackView');
        _.bindAll(this, 'play', 'pause', 'previous', 'next');
    },

    play: function(event){
        console.log('unpause');
        this.send(getCommand(command_unpause));
    },

    pause: function(event){
        console.log('pause');
        this.send(getCommand(command_pause));
    },

    previous: function(event) {
        console.log('previous');
        this.send(getCommand(command_previous));
    },

    next: function(event) {
        console.log('next');
        this.send(getCommand(command_next));
    },

    send: function (command) {
        var data = '';
        var socket_playback = navigator.mozTCPSocket.open(settings.host, settings.port, { binaryType: 'string' });

        socket_playback.onopen = function (event) {
            //~ console.log('socket_playback open');
            socket_playback.send(command);
        };
        socket_playback.onclose = function (event) {
            //console.log('socket_playback closed');
        };

        socket_playback.ondata = function (event) {

            if (typeof event.data === 'string') {
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    //console.log(data);

                    socket_playback.close();

                    mpd_status.update();
                }

            } else {
                console.error('Fuck, received data is shitty');
                socket_playback.close();
            }
        };
    }
});

var playbackView = new PlaybackView();
