$(function(){

    var searchId = null;
    var searchElementsList     = document.getElementsByClassName('search');
    var searchIconElementsList = document.getElementsByClassName('search-icon');

    for (var i=0, lengthSearchEl=searchElementsList.length; i<lengthSearchEl; i++) {

        // Filter on keyup
        searchElementsList[i].onkeyup = function () {
            var list = this.parentNode.parentNode.parentNode.querySelector('.scrollable');

            if (searchId) {
                clearInterval(searchId);
                searchId = null;

                list.classList.remove('loading');
            }

            var filter = this.value.toLowerCase();

            list.classList.add('loading');

            searchId = setTimeout(function () {
                var items = list.childNodes;

                for (var i = 0, lengthItems = items.length; i < lengthItems; i++) {
                    // Don't hide first letter titles
                    if ( (items[i].firstChild) && (items[i].firstChild.tagName != 'H1') ) {
                        if (items[i].textContent.toLowerCase().contains(filter)) {
                            items[i].classList.remove('hidden');
                        } else {
                            items[i].classList.add('hidden');
                        }
                    }
                }

                list.classList.remove('loading');
                searchId = null;
            }, 0);
        };

    }

    for (var j=0, lengthSearchIcons=searchIconElementsList.length; j<lengthSearchIcons; j++) {

        // Show/hide filter input on click
        searchIconElementsList[j].addEventListener('click', function (evt) {
            var region = this;
            while(region.getAttribute('role') != 'region') {
                region = region.parentNode;
            }

            var input = region.querySelector('.search');
            var h1    = region.querySelector('header > h1');
            var indexLetters = region.querySelector('#indexLetters');

            input.value = '';

            if (input.style.display === 'none') {
                input.style.display = 'block';
                input.focus();

                h1.style.display    = 'none';
                region.querySelector('.search-icon').classList.add('active');

                if (indexLetters) {
                    input.setAttribute('data-indexletters', indexLetters.classList);
                    indexLetters.classList.remove('active');
                }
            } else {
                if ( (indexLetters) && (input.getAttribute('data-indexletters').contains('active')) ) {
                    indexLetters.click();
                } else {
                    $(input).keyup();
                }

                input.style.display = 'none';
                h1.style.display    = 'block';
                region.querySelector('.search-icon').classList.remove('active');
            }
        });

    }

});
