// Helper Functions

//Convert a given number of seconds to a formatted time.  Does not handle hours.
function toTime( seconds ) {
    if( !isNumber( seconds ) )
        return '0:00';
    var secs = Math.floor( seconds % 60 );
    return Math.floor( seconds / 60 ) + ':' + ( ( secs + "").length < 2 ? ('0' + secs ) : secs );
}

function isNumber( n ) {
    return !isNaN( parseFloat( n ) ) && isFinite( n );
}

function computeTime () {
    //~ console.log(counter.counterID + ' : ' + counter.elapsed + ' < ' + counter.time + ' = ' + (counter.elapsed < counter.time));
    if (counter.elapsed < counter.time) {
        counter.elapsed += 2;
        counter.position = counter.position = counter.elapsed / counter.time * 100;

        //~ document.getElementById('elapsed').textContent = toTime(counter.elapsed);
        document.getElementById('position').style.width = counter.position + "%";
    } else {
        console.log('counter end : ' + counter.counterID );
        counter.stopCounter();

        mpd_status.update();
    }
}

// Count up time. When song supposes to be ended, update data.
var counter = {
    time      : 0,
    elapsed   : 0,
    position  : 0,
    counterID : null,

    startCounter: function () {
        if (this.counterID === null) {
            this.counterID = window.setInterval(computeTime, 2000);
            console.log('startCounter : ' + this.counterID);
        }
    },
    stopCounter: function () {
        console.log('stopCounter : ' + this.counterID);
        window.clearInterval(this.counterID);
        this.counterID = null;
    }
};

// Status
var mpd_status = {
    status  : {},

    update : function(callbackCommand) {
        console.log('mpd_status.update');
        var self = this;
        var data = '';
        var socket_status = navigator.mozTCPSocket.open(settings.host, settings.port, { binaryType: 'string' });

        socket_status.onopen = function (event) {
            //~ console.log('socket_status open');

            socket_status.send(getCommand(command_status));
        };
        socket_status.onclose = function (event) {
            //console.log('socket_status closed');
        };
        socket_status.ondata = function (event) {

            if (typeof data === 'string') {
                data += event.data;

                if (data.lastIndexOf("OK\n") > 0) {
                    //console.log(data);

                    socket_status.close();

                    var data_splitted = data.split("\n");
                    data_splitted.forEach( function (line) {
                        var regexped = line.match(/[A-Za-z]*: .*/);

                        if (regexped) {
                            var params = regexped[0].split(": ");
                            self.status[params[0]] = params[1];
                        }
                    });

                    //~ var state  = document.getElementById("state");
                    var volumeLiquid = document.getElementById("volume-liquid");
                    var volumeValue  = document.getElementById("volume-value");
                    var repeat = document.getElementById("repeat");
                    var random = document.getElementById("random");
                    var single = document.getElementById("single");

                    var artist = document.getElementById("artist");
                    var album  = document.getElementById("album");
                    var title  = document.getElementById("title");

                    var play  = document.getElementById('play');
                    var pause = document.getElementById('pause');
                    var div_playback = document.getElementById('div-playback');

                    //~ state.innerHTML = self.status['state'];
                    volumeLiquid.style.width = self.status.volume + "%";
                    volumeValue.innerHTML    = self.status.volume;
                    repeat.value = self.status.repeat;
                    random.value = self.status.random;
                    single.value = self.status.single;

                    if (repeat.value) {
                        repeat.classList.add('audio-setting-active');
                        repeat.querySelector('span').hidden = false;
                    } else {
                        repeat.classList.remove('audio-setting-active');
                        repeat.querySelector('span').hidden = true;
                    }
                    if (random.value) {
                        random.classList.add('audio-setting-active');
                        random.querySelector('span').hidden = false;
                    } else {
                        random.classList.remove('audio-setting-active');
                        random.querySelector('span').hidden = true;
                    }
                    if (single.value) {
                        single.classList.add('audio-setting-active');
                        single.querySelector('span').hidden = false;
                    } else {
                        single.classList.remove('audio-setting-active');
                        single.querySelector('span').hidden = true;
                    }

                    artist.innerHTML = decodeURIComponent(escape(self.status.Artist));
                    album.innerHTML  = decodeURIComponent(escape(self.status.Album));
                    title.innerHTML  = decodeURIComponent(escape(self.status.Title));

                    try {
                        counter.time     = parseInt(self.status.time.split(':')[1]);
                        counter.elapsed  = parseInt(self.status.time.split(':')[0]);
                        counter.position = counter.elapsed / counter.time * 100;

                        //~ $('#elapsed').html(toTime(counter.elapsed));
                        //~ $('#time').html(toTime(counter.time));

                        if (self.status.state != "stop") {
                            div_playback.classList.remove('hidden');

                            // Playlist : flag current song
                            Backbone.pubSub.trigger('playlist:currentSong', self.status.Pos);

                            if (self.status.state == "play") {
                                console.log('status play');

                                pause.classList.remove('hidden');
                                play.classList.add('hidden');
                                div_playback.classList.remove('pause');

                                counter.startCounter();
                            } else if (self.status.state == "pause") {
                                console.log('status pause');

                                pause.classList.add('hidden');
                                play.classList.remove('hidden');
                                div_playback.classList.add('pause');

                                counter.stopCounter();
                            }
                            getCover();
                        }
                        else { // STOP
                            div_playback.classList.add('hidden');
                            counter.stopCounter();
                        }
                    } catch (e if e instanceof TypeError) {
                        // statements to handle TypeError exceptions
                        console.error('status error');
                        counter.stopCounter();
                    }
                }

            } else {
                console.error('Fuck, received data is shitty');
                socket_status.close();
            }
        };
    }
};
