/*global angular */

define(['angular'], function() {
  // this is where our app definition is
  var app = angular
    .module('app', ['mobile-navigate', 'angularMoment'])
    .value('$anchorScroll', angular.noop)
    .config(['$routeProvider', function($routeProvider) {
    

      // here we specify routes
      // which HTML and JS to execute when a certain route is requested
      $routeProvider
        .when('/', {
          templateUrl: 'views/news.html',
          controller: 'NewsCtrl'
        })
        .when('/menu', {
          templateUrl: 'views/menu.html'
        })
        .when('/content', {
          templateUrl: 'views/content.html'
        })
        .when('/sales', {
          templateUrl: 'views/sales.html'
        })
        .when('/features', {
          templateUrl: 'views/features.html'
        })
        // .when('/category', {
        //   templateUrl: 'views/category.html',
        //   controller: 'CategoryCtrl'
        // })
        .when('/category/:categoryID', {
          templateUrl: 'views/category.html',
          controller: 'CategoryCtrl'
        })
        .when('/rest/:storeCatID', {
          templateUrl: 'views/rest.html',
          controller: 'RestCtrl'
        })
        .when('/store/:storeID', {
          templateUrl: 'views/store.html',
          controller: 'StoreCtrl'
        })
        .when('/desc/:storeID', {
          templateUrl: 'views/desc.html',
          controller: 'DescCtrl'
        })
        .when('/sales', {
          templateUrl: 'views/sales.html',
          controller: 'SalesCtrl'
        })
        .when('/features', {
          templateUrl: 'views/features.html'
        })

        .when('/about', {
          templateUrl: 'views/about.html',
          controller: 'AboutCtrl'
        })
        .when('/location', {
          templateUrl: 'views/location.html'
        })
        .when('/wifi', {
          templateUrl: 'views/wifi.html'
        })
        .when('/deltamap', {
          templateUrl: 'views/deltamap.html',
          controller: 'MapCtrl'
        })


        // .when('/news', {
        //   templateUrl: 'views/news.html',
        //   controller: 'NewsCtrl'
        // })
        .when('/single/:id', {
          templateUrl: 'views/single_news.html',
          controller: 'SingleCtrl'
        })
        .otherwise({
          redirectTo: '/'
        });
    }]);
  
  app.controller('MainCtrl', ['$scope', '$navigate', '$location', function($scope, $navigate, $location) {
    $scope.$navigate = $navigate;
    var search = $location.search();
    
    $navigate.go($location.path(), 'none').search(search);
    
  }]);

  app.config(['$httpProvider', function($httpProvider) {
    delete $httpProvider.defaults.headers.common['X-Requested-With'];
  }]);

  // TouchStart is faster than click, that's why we add this here as a
  // directive. Use `ng-tap` in code rather than `ng-click`.
  app.directive('ngTap', function() {
    var isTouch = !!('ontouchstart' in window);
    return function(scope, elm, attrs) {
      // if there is no touch available, we'll fall back to click
      if (isTouch) {
        var tapping = false;
        elm.bind('touchstart', function() {
          tapping = true;
        });
        // prevent firing when someone is f.e. dragging
        elm.bind('touchmove', function() {
          tapping = false;
        });
        elm.bind('touchend', function() {
          tapping && scope.$apply(attrs.ngTap);
        });
      }
      else {
        elm.bind('click', function() {
          scope.$apply(attrs.ngTap);
        });
      }
    };
  });

  app.directive('onKeyup', function() {
    return function(scope, elm, attrs) {
      elm.bind("keyup", function() {
        scope.$apply(attrs.onKeyup);
      });
    };
  });

  return app;
});
