'use strict';

define(['app'], function(app) {
	app.controller('NewsCtrl', ['http', '$scope',
        function(http, $scope) {
        $scope.allnews = [];
		$scope.carousel = [];

        $scope.getFeed = function(_jsonPath, _skipCache){
            if (!_skipCache) _skipCache = false;

            http({
                idbCache: { cacheKey: 'news', expiresInMs: 60000, forceSkipCache: _skipCache },
                method: 'GET', 
                url: globals.RootPath + '/' + _jsonPath
            })

            .success(function(res, status){               
                if (status !== 200) return false;

                $scope.allnews = [];

                for (var i=0; i<res.data.length; i++) {
                    var news = res.data[i];
                    var catClass = '';
                    switch (news.category) {
                        case 'Dešavanja':
                            catClass = 'events';
                        break;

                        case 'Aktuelno':
                            catClass = 'current';
                        break;

                        case 'Blog':
                            catClass = 'blog';
                        break;

                        case 'Vijesti':
                            catClass = 'news';
                        break;
                    }
                    news.catClass = catClass;
                    var pubDate = moment(news.published).format("DD.MM.YYYY.");;
                    news.pubDate = pubDate;
                    $scope.allnews.push(news);
                }   
                for (var i=0; i<res.gallery.length; i++) {
                    var image = res.gallery[i];
                    $scope.carousel.push(image);
                }

                $scope.image = res.gallery[0];


                // setTimeout(function(){
                //     $('.dcSlider').bxSlider({
                //         auto: true
                //     });
                // }, 100);
            })

            .error(function(res, status){
                console.log('error status: ' + status);
                console.debug(res);
            });

            $scope.showModal='hideModal';
        }
        
        if ($scope.allnews.length <= 0) $scope.getFeed('all.json', false);

        $scope.showAll = function(){
            //showing div as categories modal
            $scope.showModal = $scope.showModal == 'showModal' ? 'hideModal' : 'showModal';
        }


        
	}]);
});