'use strict';

define(['app'], function(app) {
	app.controller('SalesCtrl', ['$http', '$scope', '$routeParams',
        function($http, $scope, $routeParams) {
        $scope.sales = [];

            $http({
                method: 'GET', 
                url: globals.RootPath + '/sales.json'
            })

            .success(function(res, status){               
                if (status !== 200) return false;

                $scope.sales = [];

                for (var i=0; i<res.data.length; i++) {
                    var sale = res.data[i];
                    // console.log(sale.percentage);
                    var saleClass = (sale.percentage*1);
                    
                        if (sale.percentage <= 20) {
                            saleClass = 'percentage20';
                        } else if (sale.percentage > 20 && sale.percentage <= 40) {
                            saleClass = 'percentage40';
                        } else if (sale.percentage > 40 && sale.percentage <= 60) {
                            saleClass = 'percentage60';
                        } else if (sale.percentage > 60 && sale.percentage <= 80) {
                            saleClass = 'percentage80';
                        } else if (sale.percentage > 80 && sale.percentage <= 100) {
                            saleClass = 'percentage100';
                        }
                    
                    sale.saleClass = saleClass;
                    var pubDate = moment(sale.published).format("DD.MM.YYYY.");;
                    sale.pubDate = pubDate;
                    $scope.sales.push(sale);

                    // console.log('class: ' + saleClass);
                }
            })

            .error(function(res, status){
                console.log('error status: ' + status);
                console.debug(res);
            });


        
            
        
	}]);
});