'use strict';

define(['app'], function(app) {
	app.controller('SingleCtrl', ['$http', '$scope', '$routeParams',
        function($http, $scope, $routeParams) {
        $scope.news = [];
		$http({
            method: 'GET', 
            url: globals.RootPath + '/all.json?id=' + $routeParams.id
        })
        .success(function(res, status){
            if (status !== 200) return false;
            
            $scope.news = res.data[0];
            var news = $scope.news
            // console.log($scope.news);
            var catClass = '';
                switch (news.category) {
                    case 'Dešavanja':
                        catClass = 'events';
                    break;

                    case 'Aktuelno':
                        catClass = 'current';
                    break;

                    case 'Blog':
                        catClass = 'blog';
                    break;

                    case 'Vijesti':
                        catClass = 'news';
                    break;
                }
                news.catClass = catClass;
                // console.log(catClass);
                var pubDate = moment(news.published).format("DD.MM.YYYY.");;
                news.pubDate = pubDate;
                //$scope.allnews.push($scope);
            
        })
        .error(function(res, status){
            console.log('error status: ' + status);
            console.debug(res);
        });
	}]);
});