'use strict';

define(['app'], function(app) {
	app.controller('StoreCtrl', ['$http', '$scope', '$routeParams',
        function($http, $scope, $routeParams) {
            
            function getStoreInfo() {
                $scope.storeInfo = {};
                $http({
                    method: 'GET', 
                    url: globals.RootPath + '/stores.json?id=' + $routeParams.storeID
                })
                .success(function(res, status){               
                    if (status !== 200) return false;
                    $scope.store = res.data[0];
                    var store = $scope.store;
                    getStoreNews();

                    if (store.gallery_image.length > 0) {
                        store.backgroundImage = store.gallery_image;
                    } else {
                        store.backgroundImage = '/images/default_background_image.png';
                    }
                })
                .error(function(res, status){
                    console.log('error status: ' + status);
                    console.debug(res);
                });
            }

            function getStoreNews() {
                $scope.allStoreNews = [];
                
                $http({
                    method: 'GET', 
                    url: globals.RootPath + '/all.json?store=' + $routeParams.storeID
                })

                .success(function(res, status){               
                    if (status !== 200) return false;
                    $scope.allStoreNews = [];
                    for (var i=0; i<res.data.length; i++) {
                        var newsStore = res.data[i];
                        var catClass = '';
                        switch (newsStore.category) {
                            case 'Dešavanja':
                                catClass = 'events';
                            break;

                            case 'Aktuelno':
                                catClass = 'current';
                            break;

                            case 'Blog':
                                catClass = 'blog';
                            break;

                            case 'Vijesti':
                                catClass = 'news';
                            break;
                        }
                        newsStore.catClass = catClass;
                        var pubDate = moment(newsStore.published).format("DD.MM.YYYY.");;
                        newsStore.pubDate = pubDate;
                        $scope.allStoreNews.push(newsStore);


                    }

                    getStoreSimilar();
                })

                .error(function(res, status){
                    console.log('error status: ' + status);
                    console.debug(res);
                });
            }

            function getStoreSimilar() {
                $scope.similarStores = [];
                $http({
                    method: 'GET', 
                    url: globals.RootPath + '/similar_stores.json?id=' + $routeParams.storeID
                })
                .success(function(res, status){               
                    if (status !== 200) return false;

                    $scope.similarStores = [];
                    for (var i=0; i<res.data.length; i++) {
                        var store = res.data[i];
                        var pubDate = moment(store.published).format("DD.MM.YYYY.");;
                        store.pubDate = pubDate;
                        $scope.similarStores.push(store);
                    if (store.gallery_image.length > 0) {
                        store.backgroundImage = store.gallery_image;
                    } else {
                        store.backgroundImage = '/images/default_background_image.png';
                    }
                    }

                })

                .error(function(res, status){
                    console.log('error status: ' + status);
                    console.debug(res);
                });
            }

            function getStoreSales() {
                $scope.sales = [];

                $http({
                    method: 'GET', 
                    url: globals.RootPath + '/sales.json?store=' + $routeParams.storeID
                })

                .success(function(res, status){               
                    if (status !== 200) return false;

                    $scope.sales = [];

                    for (var i=0; i<res.data.length; i++) {
                        var sale = res.data[i];
                        var saleClass = (sale.percentage*1);
                        
                            if (sale.percentage <= 20) {
                                saleClass = 'percentage20';
                            } else if (sale.percentage > 20 && sale.percentage <= 40) {
                                saleClass = 'percentage40';
                            } else if (sale.percentage > 40 && sale.percentage <= 60) {
                                saleClass = 'percentage60';
                            } else if (sale.percentage > 60 && sale.percentage <= 80) {
                                saleClass = 'percentage80';
                            } else if (sale.percentage > 80 && sale.percentage <= 100) {
                                saleClass = 'percentage100';
                            }
                        
                        sale.saleClass = saleClass;
                        var pubDate = moment(sale.published).format("DD.MM.YYYY.");;
                        sale.pubDate = pubDate;
                        $scope.sales.push(sale);

                        $scope.salesFetched = true;

                        //var counter = res.data.length;
                        //console.log('counter:' + counter);
                    }
                })

                .error(function(res, status){
                    console.log('error status: ' + status);
                    console.debug(res);
                });

            }

            $scope.switchTab = function(section){
                switch(section){
                    case 'info':
                        $scope.section_info = true;
                        $scope.section_sales = false;
                        $scope.section_map = false;


                    break;

                    case 'sales':
                        $scope.section_info = false;
                        $scope.section_sales = true;
                        $scope.section_map = false;

                        if (!$scope.salesFetched)  getStoreSales();

                    break;

                    case 'map':
                        $scope.section_info = false;
                        $scope.section_sales = false;
                        $scope.section_map = true;


                    break;

                }
            }
            
            getStoreInfo();
            $scope.section_info = true;
        
	}]);
});