'use strict';
define(['app'], function(app) {
  app.filter('xmlFilter', ['$window', function ($window) {
      return function (input) {
        
        var xmlDoc, parser;
        
        if ($window.DOMParser) {
          parser = new $window.DOMParser();
          xmlDoc = parser.parseFromString(input, 'text/xml');
        } else if ($window.ActiveXObject) {
          // IE
          xmlDoc = new $window.ActiveXObject('Microsoft.XMLDOM');
          xmlDoc.async = false;
          xmlDoc.loadXml(input);
        } else {
          throw new Error('Cannot parse XML in this environment.');
        }

        return ng.element(xmlDoc);
        
      };
    }]);
});