function formatAllInputs() {
	var tipAmount = $('#tip_amount').val();
	var totalAmount = $('#total_amount').val();
	var eachPersonPays = $('#each_person_pays').val();

	$('#tip_amount').val(tipAmount.toFixed(2));
	$('#total_amount').val(totalAmount.toFixed(2));
	$('#eachPersonPays').val(eachPersonPays.toFixed(2));
}

function calculateTotalAmount(tipPercentFirst) {
	var billAmount = $('#bill_amount').val();
	var tipPercent = $('#tip_percent').val();
	var tipAmount = $('#tip_amount').val();

	if(tipPercentFirst) {
		if(tipPercent != null) {
			tipAmount = billAmount * tipPercent / 100;
			tipAmount = parseFloat(tipAmount.toFixed(2));
			$('#tip_amount').val(tipAmount);
		} else if(tipAmount != null) {
			tipPercent = tipAmount / billAmount * 100;
			tipPercent = parseFloat(tipPercent.toFixed(2));
		}
	} else {
		if(tipAmount != null) {
			tipPercent = tipAmount / billAmount * 100;
			tipPercent = parseFloat(tipPercent.toFixed(2));
			$('#tip_percent').val(tipPercent);
		} else if(tipPercent != null) {
			tipAmount = billAmount * tipPercent / 100;
			tipAmount = parseFloat(tipAmount.toFixed(2));
		}
	}

	totalAmount = parseFloat(billAmount) + parseFloat(tipAmount);
	$('#total_amount').val(totalAmount.toFixed(2));
}

function calculateEachPersonPays() {
	var totalAmount = $('#total_amount').val();
	var numberOfPeople = $('#number_of_people').val();
	eachPersonPays = totalAmount / numberOfPeople;
	eachPersonPays = parseFloat(eachPersonPays.toFixed(2));
	$('#each_person_pays').val(eachPersonPays);
}


function calculateResultsForBillAmount(tipPercentFirst) {
	calculateTotalAmount(tipPercentFirst);
	calculateEachPersonPays();
}

function calculateResultsForTotalAmount() {
	var billAmount = $('#bill_amount').val();
	var totalAmount = $('#total_amount').val();

	var tipAmount = totalAmount - billAmount;
	var tipPercent = tipAmount / billAmount * 100;

	$('#tip_amount').val(tipAmount);
	$('#tip_percent').val(tipPercent);
}

function calculateResultsForEachPersonPays() {
	var numberOfPeople = $('#number_of_people').val();
	var eachPersonPays = $('#each_person_pays').val();

	var totalAmount = numberOfPeople * eachPersonPays;
	$('#total_amount').val(totalAmount);

	calculateResultsForTotalAmount();
}

function clearInputs() {
	$('#bill_amount').val('');
	$('#tip_percent').val('');
	$('#tip_amount').val('');
	$('#total_amount').val('');
	$('#number_of_people').val('');
	$('#each_person_pays').val('');
}


$(document).ready(function(){
	$('#bill_amount').keyup(function(){
		calculateResultsForBillAmount(true);
	});

	$('#tip_percent').keyup(function(){
		calculateResultsForBillAmount(true);
	});

	$('#tip_amount').keyup(function(){
		calculateResultsForBillAmount(false);
	});

	$('#total_amount').keyup(function(){
		calculateResultsForTotalAmount();
	});

	$('#number_of_people').keyup(function(){
		calculateResultsForBillAmount();
	});

	$('#each_person_pays').keyup(function(){
		calculateResultsForEachPersonPays();
	});

	$('#action_clear').click(function(){
		clearInputs();
	});
});