var exchange = {
	"date": "",
	"currency": {
		"eur": {},
		"usd": {},
		"chf": {},
		"gbp": {},
		"aud": {},
		"cad": {},
		"rub": {},
		"jpy": {},
		"nok": {},
		"sek": {},
		"dkk": {}
	}
};

$(document).ready(function() {
	$(".drawerbtn").click(function() {
		$("#home").addClass("outleft");
		$("#calc").removeClass("outright");
	});

	$(".backbtn").click(function() {
		$("#home").removeClass("outleft");
		$("#calc").addClass("outright");
	});

	asyncStorage.getItem("exchange-update", function(value) {

		if(value != null && timestamp() - value < 12*60*60) {
			asyncStorage.getItem("exchange-list", function(list) {
				exchange = list;
				showData();
			});
		}
		else {
			$.get("http://www.nbs.rs/kursnaListaModul/srednjiKurs.faces?lang=lat").done(function(data) {

				$html = $($.parseHTML(data));
				$html.find(".tableCell tbody tr").each(function() {
					var tr = $(this);
					var cur = tr.find("td:nth-child(3)").text().toLowerCase();
					var ind = parseInt(tr.find("td:nth-child(4)").text());
					var srednji = parseFloat(tr.find("td:nth-child(5)").text().replace(",",".")).toFixed(2);
					if(exchange.currency[cur]) {
						exchange.currency[cur].ind = ind;
						exchange.currency[cur].srednji = srednji;
					}
				});
				exchange.date = $html.find("table .bold span:nth-child(8)").text();

				$.get("http://www.nbs.rs/kursnaListaModul/zaDevize.faces?lang=lat").done(function(dat) {

					$htm = $($.parseHTML(dat));
					$htm.find(".tableCell tbody tr").each(function() {
						var tr = $(this);
						var cur = tr.find("td:nth-child(3)").text().toLowerCase();
						var ind = parseInt(tr.find("td:nth-child(4)").text());
						var kupovni = parseFloat(tr.find("td:nth-child(5)").text().replace(",",".")).toFixed(2);
						var prodajni = parseFloat(tr.find("td:nth-child(6)").text().replace(",",".")).toFixed(2);
						if(exchange.currency[cur]) {
							exchange.currency[cur].ind = ind;
							exchange.currency[cur].kupovni = kupovni;
							exchange.currency[cur].prodajni = prodajni;
						}
					});

					asyncStorage.setItem("exchange-list", exchange);
					asyncStorage.setItem("exchange-update", timestamp());

					showData();

				}).fail(function() {
					if(value == null) {
						alert("Učitavanje nije uspelo! Proverite internet konekciju!");
						$("#loading").fadeOut("slow");
					}
					else {
						alert("Učitavanje nije uspelo! Proverite internet konekciju! Učitana je poslednja tabela.");
						asyncStorage.getItem("exchange-list", function(list) {
							exchange = list;
							showData();
						});
					}
				});

			}).fail(function() {
				if(value == null) {
					alert("Učitavanje nije uspelo! Proverite internet konekciju!");
					$("#loading").fadeOut("slow");
				}
				else {
					alert("Učitavanje nije uspelo! Proverite internet konekciju! Učitana je poslednja tabela.");
					asyncStorage.getItem("exchange-list", function(list) {
						exchange = list;
						showData();
					});
				}
			});
		}
	});

	$("#currency").change(function() {
		var curr = $(this).val().toUpperCase();
		$("#deviza").attr("placeholder", curr);
		$("label[for='deviza']").text(curr);
	});

	$("input").keyup(function() {
		if($(this).attr("id") == "dinar") {
			var sel = $("#currency").val();

			var cur = exchange.currency[sel].srednji / exchange.currency[sel].ind;
			var rsd = $(this).val();

			$("#deviza").val((rsd/cur).toFixed(2));
		}
		if($(this).attr("id") == "deviza") {
			var sel = $("#currency").val();

			var cur = exchange.currency[sel].srednji / exchange.currency[sel].ind;
			var dev = $(this).val();

			$("#dinar").val((dev*cur).toFixed(2));
		}
	}).focus(function() {
		$(this).val("");
	});
});

function timestamp() {
	return Math.round((new Date()).getTime() / 1000);
}


function showData() {
	$("[data-value='date']").text(exchange.date);
	$.each(exchange.currency, function(key, val) {
		$("[data-currency='"+key+"'] [data-value='index']").text(val.ind);
		$("[data-currency='"+key+"'] [data-value='kupovni']").text(val.kupovni);
		$("[data-currency='"+key+"'] [data-value='srednji']").text(val.srednji);
		$("[data-currency='"+key+"'] [data-value='prodajni']").text(val.prodajni);
	});

	$("#loading").fadeOut("slow");
	$("#list").fadeIn("slow");
	$("#gocalc").fadeIn("slow");
}