//
//	TouchHandler.js
//
//	Created by Nikolas Hansen on 02.07.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function TouchHandler() {
  this.update_function = null
}

TouchHandler.prototype.init = function() {

}

TouchHandler.prototype.activate = function() {
  Zepto('#screen').on('mousedown touchstart', Zepto.proxy(function(event) {this.onTouchStart(event);}, this));
  Zepto('#screen').on('mouseup touchend', Zepto.proxy(function(event) {this.onTouchStop(event);}, this));
  
}

TouchHandler.prototype.deactivate = function() {
  Zepto('#screen').off('mousedown mousemove mouseup touchstart touchmove touchend');
}


TouchHandler.prototype.onTouchStart = function(event) {
	if (event.target.id == "settings_button") {
		return;
	}
  this.update(event);
	Zepto('#arrows').animate({opacity:0.5}, 100, 'ease-in');

  Zepto('#screen').on('mousemove touchmove', Zepto.proxy(function(event) {this.onTouchMove(event);}, this));
}


TouchHandler.prototype.onTouchMove = function(event) {
  this.update(event);
}

TouchHandler.prototype.onTouchStop = function(event) {
	Zepto('#arrows').animate({opacity:0.0}, 250, 'ease-out');
  Zepto('#screen').off('mousemove touchmove');
}

TouchHandler.prototype.update = function(event) {
  //event.preventDefault();
  
  if (event.touches) {
		fingerX = event.touches[0].pageX;
		fingerY = event.touches[0].pageY;
  } else {
		fingerX = event.pageX;
		fingerY = event.pageY;
  }
  //console.log("x: " + fingerX + ", y: "+ fingerY);

  if (this.update_function != null) {
		this.update_function(fingerX, fingerY);
  }
}

