//
//	colored_light_controller.js
//
//	Created by Nikolas Hansen on 16.07.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function ColoredLightController(base) {
  this.base = base;
  this.name = "colored_light";
  this.type = "full";
}


ColoredLightController.prototype.init = function() {
  this.templates = [];
  this.base.loadTemplate(this, "main");
}


ColoredLightController.prototype.setup = function() {
  color_chooser.inkScreen();
}


ColoredLightController.prototype.activate =  function() {
  Zepto('#settings_button').on('click', function(event) {
		event.preventDefault();
		view_controller.showView("settings");
	});
	
  touch_handler.update_function = this.screenUpdate;
  touch_handler.activate();
}


ColoredLightController.prototype.show = function() {
	Zepto('#arrows').animate({opacity: 1.0}, 500);
}


ColoredLightController.prototype.deactivate = function() {
	touch_handler.deactivate();
  Zepto("*").off();
}


//*********************************************

ColoredLightController.prototype.handleClickEvent = function(event) {
  var id = event.target.id;
  if ( id === "buttonBack" ) {
		this.base.showView(0);
  } 
}

ColoredLightController.prototype.screenUpdate = function(x, y) {
	var sine = Math.cos((y / window.innerHeight)*Math.PI);
  //var lightness = 0.5 + 0.5*sine;
	var lightness = 1 - (y / window.innerHeight);
  var hue = x / window.innerWidth;

  color_chooser.setHsl(hue, null, lightness);
  color_chooser.inkScreen();
}
