//
//	morse_code_controller.js
//
//	Created by Nikolas Hansen on 16.07.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function MorseCodeController(base) {
  this.base = base;
  this.name = "morse_code";
  this.type = "full";

  this.message = "";
  this.running = false;
}

MorseCodeController.prototype.init = function() {
  this.templates = [];
  this.base.loadTemplate(this, "main");
}


MorseCodeController.prototype.setup = function() {
  Zepto('#content').css('background', '#888');	

  Zepto("#title").html($L("Morse Encoder"));
  Zepto("#text_input").attr("placeholder", $L("Text"));
  Zepto("#start_stop_button").html($L("Start"));
  Zepto("#repeat_button").html($L("Repeat"));
}


MorseCodeController.prototype.activate =  function() {
  Zepto('#settings_button').on('click', function() {view_controller.showView("settings");});

  Zepto('#setup').on('click', 'button', Zepto.proxy(function(event) {this.handleClickEvent(event)}, this));
}


MorseCodeController.prototype.show = function() {
}


MorseCodeController.prototype.deactivate = function() {
  Zepto("*").off();
}

//*****************************************

MorseCodeController.prototype.handleClickEvent = function(event) {
  var id = event.target.id;
  if (id == "start_stop_button") {
		if (!this.running) {
	    this.message = Zepto('#text_input').val() + " ";			
			if (this.message != "") {
				Zepto("#start_stop_button").addClass('active');
				Zepto("#start_stop_button").html($L("Stop"));
				this.running = true;
				Zepto(document).on('morse_finished', Zepto.proxy(function() {this.finished();}, this));
				Zepto("#setup_container").animate({opacity: 0.25}, 500, 'ease-out');
				morse_encoder.startMorse(this.message);
	   	}
			
		} else {			
			morse_encoder.stopMorse();
	    Zepto(document).trigger('morse_finished');
	    Zepto(document).off('morse_finished', Zepto.proxy(function() {this.finished}, this));

		}
  } else if (id == "repeat_button") {
		if (!morse_encoder.repeat) {
	    morse_encoder.repeat = true;
	    Zepto("#repeat_button").addClass('active');
		} else {
	    morse_encoder.repeat = false;
	    Zepto("#repeat_button").removeClass('active');
		}
  }

}

MorseCodeController.prototype.finished = function() {
	Zepto('#content').css('background', '#888');	
	Zepto("#setup_container").animate({opacity: 1.0}, 500, 'ease-in');
  Zepto("#start_stop_button").removeClass('active');
  Zepto("#start_stop_button").html($L("Start"));
  this.running = false;
}