//
//	settings_controller.js
//
//	Created by Nikolas Hansen on 16.07.13.
//	Copyright (c) 2013 Nikolas Hansen. All rights reserved.
//

function SettingsController(base) {
  this.base = base;
  this.name = "settings";
  this.type = "popup";
}

SettingsController.prototype.init = function() {
  this.templates = [];
  this.base.loadTemplate(this, "main");
}

SettingsController.prototype.setup = function() {
	Zepto('#title').html($L('Menu'));
	
  Zepto('#title_simple_light').html($L('Simple Flashlight'));
  Zepto('#title_colored_light').html($L('Colored Flashlight'));
  Zepto('#title_morse_code').html($L('Morse Encoder'));
  Zepto('#title_ambient_light').html($L('Ambient Light'));

  var mode = settings.get("mode"); 
  Zepto("#settings input").removeAttr("checked");
  if (mode == "simple") {
		Zepto("#radio_simple_light").attr("checked", true);

  } else if (mode == "colored") {
		Zepto("#radio_colored_light").attr("checked", true);


  } else if (mode == "morse") {
		Zepto("#radio_morse_code").attr("checked", true);

  } else if (mode == "ambient") {
		Zepto("#radio_ambient_light").attr("checked", true);

  }
}


SettingsController.prototype.activate =  function() {
  Zepto('#back_button').on('click', function() {view_controller.hidePopup()});
  Zepto('#info_button').on('click', function() {view_controller.showView("info")});

  Zepto('#simple_light').on('click', Zepto.proxy(function(event) {this.handleClickEvent('simple_light')}, this));
  Zepto('#colored_light').on('click', Zepto.proxy(function(event) {this.handleClickEvent('colored_light')}, this));
  Zepto('#morse_code').on('click', Zepto.proxy(function(event) {this.handleClickEvent('morse_code')}, this));
  Zepto('#ambient_light').on('click', Zepto.proxy(function(event) {this.handleClickEvent('ambient_light')}, this));

}


SettingsController.prototype.show = function() {
}


SettingsController.prototype.deactivate = function() {
  Zepto("*").off();
}

SettingsController.prototype.handleClickEvent = function(name) { 
  if (name == "simple_light") {
		Zepto("#radio_simple_light").attr('checked', true);
		settings.set("mode", "simple");
		view_controller.showView("simple_light");

  } else if (name == "colored_light") {
		Zepto("#radio_colored_light").attr('checked', true);
		settings.set("mode", "colored");
		view_controller.showView("colored_light");

  } else if (name == "morse_code") {
		Zepto("#radio_morse_code").attr('checked', true);
		settings.set("mode", "morse");
		view_controller.showView("morse_code");

  } else if (name == "ambient_light") {		Zepto("#settings input").removeAttr('checked');
		Zepto("#radio_ambient_light").attr('checked', true);
		settings.set("mode", "ambient");
		view_controller.showView("ambient_light");

  }

	return;
}