/*
 *
 *  zCalc
 *
 *  @author Mozart Diniz
 *  @date 2013-11-12 04:00
 *
 *
 * */

Globalize.cultureSelector = window.navigator.language;
var culture = Globalize.culture ();
var decimalComparator = culture.numberFormat['.'];

var operationsPipe = [0];
var result = document.getElementById ('result');
var btns = document.querySelectorAll ('.number');
var operators = document.querySelectorAll ('.operator');
var bkspace = document.getElementById ('bksp');
var equal = document.getElementById ('equal');
var tape = document.getElementById ('tapeText');
var tapeContainer = document.getElementById ('tapeContainer');
var ce = document.getElementById ('ce');
var invert = document.getElementById ('invert');
var percentBtn = document.getElementById ('percent');
var dot = document.getElementById ('dot');

function writeTextToTape (text) {

    tape.innerHTML += text;

    var tapeWith = tape.innerHTML.length * 10;

    tape.style.width = tapeWith + 'px';
    tapeContainer.scrollLeft = tapeContainer.scrollWidth;
}

function clearResult () {
    result.innerHTML = '0';
}

function parseNumbers (strNumber) {
    return Globalize.parseFloat (strNumber);
}

function addValueToResult (e) {

    if(result.innerHTML !== '0') {
        result.innerHTML += e.target.getAttribute ('value');
    } else {
        result.innerHTML = e.target.getAttribute ('value');
    }

}

function backspace () {

    var leftNumber = result.innerHTML.substr (0, result.innerHTML.length - 1);

    if(leftNumber === '') {
        clearResult ();
    } else {
        result.innerHTML = leftNumber;
    }

}

function addNumberToPipe () {

    operationsPipe.push (parseNumbers (result.innerHTML));
    operationsPipe.push (this.getAttribute ('value'));

    writeTextToTape (' ' + Globalize.format (parseNumbers (result.innerHTML), 'n'));
    writeTextToTape (' ' + this.getAttribute ('value'));

    clearResult ();

}

function processOperationsPipe (lastA) {

    var a = lastA || null, b, o, final;

    if(!a) {
        final = operationsPipe.shift ();
        a = operationsPipe.shift ();
    }

    o = operationsPipe.shift ();
    b = operationsPipe.shift ();

    final = calc (a, o, b);

    if(operationsPipe.length) {
        final = processOperationsPipe (final);
    }

    return final;
}

function getResult () {

    if(operationsPipe.length > 1) {

        operationsPipe.push (parseNumbers (result.innerHTML));

        writeTextToTape (' ' + Globalize.format (parseNumbers (result.innerHTML), 'n'));

        var total = processOperationsPipe ();

        result.innerHTML = Globalize.format(total, 'n');

        operationsPipe = [];
        operationsPipe.push (total);

        writeTextToTape (' = ' + Globalize.format(total, 'n') + '; ');
    }

}

function calc (a, o, b) {

    switch (o) {
        case '+':
            return a + b;
        case '-':
            return a - b;
        case '÷':

            if(b) {
                return a / b;
            }

            return a;
        case 'x':
            return a * b;

    }
}

function ajustVisual () {

    var calculatorTable = document.querySelector ('table.calculator');
    var tapeContainer = document.getElementById ('tapeContainer');

    calculatorTable.style.height = window.innerHeight + 'px';
    tapeContainer.style.width = window.innerWidth + 'px';

}

function clearAll () {
    tape.innerHTML = '';
    result.innerHTML = '0';
    operationsPipe = [0];
}

function invertValue () {

    var valueNumber = Globalize.parseFloat (result.innerHTML);

    result.innerHTML = Globalize.format(valueNumber * -1, 'n');

}

function calcPercent () {

    operationsPipe.shift ();
    var a = operationsPipe[0];
    var o = operationsPipe[1];
    var p = Globalize.parseFloat (result.innerHTML);

    if(o === '+') {
        p = p / 100 + 1;
    } else {
        p = p / 100;
    }

    result.innerHTML = Globalize.format(a * p, 'n');
    tape.innerHTML = '';

    operationsPipe = [a * p];

}

function addInternacionalizedDecimal () {

    result.innerHTML += decimalComparator;

}

function addListeners () {

    // numbers 1-0
    for(var btn = 0, l = btns.length; btn < l; btn++) {
        btns[btn].addEventListener ('click', addValueToResult);
    }

    // operators
    for(var i = 0, l = operators.length; i < l; i++) {
        operators[i].addEventListener ('click', addNumberToPipe);
    }

    //backpsace
    bkspace.addEventListener ('click', backspace);

    //calc
    equal.addEventListener ('click', getResult);

    //ce
    ce.addEventListener ('click', clearAll);

    //invert
    invert.addEventListener ('click', invertValue);

    //calc percent
    percentBtn.addEventListener ('click', calcPercent);

    //dot
    dot.addEventListener ('click', addInternacionalizedDecimal);

}

function init () {
    addListeners ();
    ajustVisual ();
}

document.addEventListener ('DOMContentLoaded', init);

window.addEventListener ('resize', ajustVisual);