
// This uses require.js to structure javascript:
// http://requirejs.org/docs/api.html#define
define(function(require) {
    // Zepto provides nice js and DOM methods (very similar to jQuery,
    // and a lot smaller):
    // http://zeptojs.com/
    // var $ = require('zepto');
    require('jquery');
    require('smoothZoom');
    // Handlebars provides the power necessary to let you build semantic 
    // templates effectively with no frustration.
    // http://handlebarsjs.com
    // var Handlebars = require('handlebars');
    // Need to verify receipts? This library is included by default.
    // https://github.com/mozilla/receiptverifier
    require('receiptverifier');

    // Want to install the app locally? This library hooks up the
    // installation button. See <button class="install-btn"> in
    // index.html
    require('./install-button');

    setTimeout(function () {
        var Atto = require('Atto'),
            config = require('config'),
            start = new Date().getTime(),
            body = $(document.body),
            home = $('#list'),
            attractions,
            nightlife,
            publicTransportMap,
            shopping;

        require('components');

        $('.js-attractions').on('click', function () {
            if (!attractions) {
                attractions = $(Atto.create('attractions-list', {title:'Attractions', home: home}).render());
                body.append(attractions);
            }
            home.attr('data-direction', 'left');
            home.removeClass('show');
            home.addClass('hide');

            attractions.attr('data-direction', 'left');
            attractions.removeClass('hide');
            attractions.addClass('show');
        });
        
        $('.js-nightlife').on('click', function () {
            if (!nightlife) {
                nightlife = $(Atto.create('nightlife-list', {title:'Nightlife', home: home}).render());
                body.append(nightlife);
            }
            home.attr('data-direction', 'left');
            home.removeClass('show');
            home.addClass('hide');

            nightlife.attr('data-direction', 'left');
            nightlife.removeClass('hide');
            nightlife.addClass('show');
        });
        
        $('.js-public-transport-map').click(function () {
            // var list = $('#list');
            if (!publicTransportMap) {
        		publicTransportMap = $(Atto.create('public-transport-map', {title:'Nightlife', home: home}).render());
                body.append(publicTransportMap);
            }
            home.attr('data-direction', 'left');
            home.removeClass('show');
            home.addClass('hide');

            publicTransportMap.attr('data-direction', 'left');
            publicTransportMap.removeClass('hide');
            publicTransportMap.addClass('show');
            return;
            // set title
            $('.header-title', publicTransportMap).html('AHA?');
            list.attr('data-direction', 'left');
            publicTransportMap.attr('data-direction', 'left');
            list.removeClass('show');
            list.addClass('hide');
            publicTransportMap.removeClass('hide');
            publicTransportMap.addClass('show');
            $('.header-back-button', publicTransportMap).attr('data-return', '#list');
            $('.header-back-button', publicTransportMap).attr('data-activ-id', '#section_public_transport_map');
        });
        
        $('.js-shopping').on('click', function () {
            if (!shopping) {
                shopping = $(Atto.create('shopping-list', {title:'Shopping', home: home}).render());
                body.append(shopping);
            }
            home.attr('data-direction', 'left');
            home.removeClass('show');
            home.addClass('hide');

            shopping.attr('data-direction', 'left');
            shopping.removeClass('hide');
            shopping.addClass('show');
        });

    }, 600);
    // Atto.run();
});

