var mapa = L.map("mapa");
var capaUbicacion = null;
var capaLugares = null;
var geoJSON =  null;

if (!localStorage["latitud"] && !localStorage["longitud"])
{
	localStorage["latitud"] = null;
	localStorage["longitud"] = null;
}	

if (localStorage["latitud"] !== "null" && localStorage["longitud"] !== "null")
	mapa.setView([localStorage["latitud"], localStorage["longitud"]], 14);
else
	mapa.setView([19.4326, -99.1332], 14);

L.tileLayer("http://a.tiles.mapbox.com/v3/moteles-ffos-codear.map-wk5rdc09/{z}/{x}/{y}.png", {
    attribution: '&copy; <a href="http://www.mapbox.com/tos/">MapBox</a> contributors'
}).addTo(mapa);

function pedirJSON(lat, lng)
{
	var xhr = new XMLHttpRequest();
	xhr.open("GET", "http://api.codear.la/paseapp/lugares/?lat="+ lat + "&lng=" + lng + "&cat=moteles&tipo=json", false);

	xhr.onreadystatechange = function()
	{
		if (xhr.status === 200)
			if (xhr.readyState === 4)
			{
				geoJSON = JSON.parse(xhr.response);
		
				if (geoJSON.features != 0)
					mapa.fitBounds([[lat, lng], [geoJSON.features[0].geometry.coordinates[1], geoJSON.features[0].geometry.coordinates[0]]], {animate: false});
			}
	}

	xhr.onerror = function(){
		alert("Error obtiendo los lugares");
		return;
	}

	xhr.send();

	return geoJSON;
}

function agregarUbicacion(lat, lng)
{
	localStorage["latitud"] = lat;
	localStorage["longitud"] = lng;

	if (capaUbicacion)
	{
		mapa.removeLayer(capaUbicacion);
		capaUbicacion = null;
	}

	var iconoUbicacion = L.icon({
		iconUrl: "./imagenes/pin_ubicacion.png",
		iconSize: [24, 24],
		iconAnchor: [14, 14],
		popupAnchor: [0, -20]
	});

	mapa.setView([lat, lng], 14);

	capaUbicacion = L.marker([lat, lng], {icon: iconoUbicacion, clickable: false, riseOnHover: true }).addTo(mapa);
}

function agregarLugares(lat, lng)
{

	if (capaLugares)
	{
		mapa.removeLayer(capaLugares);
		capaLugares = null;
	}

	geoJSON = pedirJSON(lat, lng);

	if (geoJSON.features == 0)
	{
		mapa.setView([lat, lng], 15);
		alert("Actualmente no tenemos moteles cercanos a tu ubicación");	
	}

	function onEachFeature(feature, layer) {
		if (feature.properties && feature.properties.popupContent)
        	layer.bindPopup(feature.properties.popupContent);
	};

	var iconoLugar = L.icon({
		iconUrl: "./imagenes/pin_motel_off.png",
		iconSize: [35, 90],
		iconAnchor: [17, 20],
		popupAnchor: [0, -20]
	});

	capaLugares = L.geoJson(geoJSON, {
		style: function (feature) {
			return feature.properties && feature.properties.style;
		},

		onEachFeature: onEachFeature,

		pointToLayer: function(feature, latlng){
			return L.marker(latlng, {icon: iconoLugar, riseOnHover: true, bounceOnAdd: true, bounceOnAddOptions: {duration: 1300}});
		}
	}).addTo(mapa);

}

//Boton para pedir ubicación...
document.querySelector("#btnUbicacion").addEventListener("click", function(){
	navigator.geolocation.getCurrentPosition(function(position){
			agregarUbicacion(position.coords.latitude, position.coords.longitude);
			agregarLugares(position.coords.latitude, position.coords.longitude);
		}, function(){
			alert("Error obteniendo tu ubicación");
		}, { enableHighAccuracy: true, timeout: 8000 });
});