/*
    json2.js
    2012-10-08

    Public Domain.

    NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.

    See http://www.JSON.org/js.html


    This code should be minified before deployment.
    See http://javascript.crockford.com/jsmin.html

    USE YOUR OWN COPY. IT IS EXTREMELY UNWISE TO LOAD CODE FROM SERVERS YOU DO
    NOT CONTROL.


    This file creates a global JSON object containing two methods: stringify
    and parse.

        JSON.stringify(value, replacer, space)
            value       any JavaScript value, usually an object or array.

            replacer    an optional parameter that determines how object
                        values are stringified for objects. It can be a
                        function or an array of strings.

            space       an optional parameter that specifies the indentation
                        of nested structures. If it is omitted, the text will
                        be packed without extra whitespace. If it is a number,
                        it will specify the number of spaces to indent at each
                        level. If it is a string (such as '\t' or '&nbsp;'),
                        it contains the characters used to indent at each level.

            This method produces a JSON text from a JavaScript value.

            When an object value is found, if the object contains a toJSON
            method, its toJSON method will be called and the result will be
            stringified. A toJSON method does not serialize: it returns the
            value represented by the name/value pair that should be serialized,
            or undefined if nothing should be serialized. The toJSON method
            will be passed the key associated with the value, and this will be
            bound to the value

            For example, this would serialize Dates as ISO strings.

                Date.prototype.toJSON = function (key) {
                    function f(n) {
                        // Format integers to have at least two digits.
                        return n < 10 ? '0' + n : n;
                    }

                    return this.getUTCFullYear()   + '-' +
                         f(this.getUTCMonth() + 1) + '-' +
                         f(this.getUTCDate())      + 'T' +
                         f(this.getUTCHours())     + ':' +
                         f(this.getUTCMinutes())   + ':' +
                         f(this.getUTCSeconds())   + 'Z';
                };

            You can provide an optional replacer method. It will be passed the
            key and value of each member, with this bound to the containing
            object. The value that is returned from your method will be
            serialized. If your method returns undefined, then the member will
            be excluded from the serialization.

            If the replacer parameter is an array of strings, then it will be
            used to select the members to be serialized. It filters the results
            such that only members with keys listed in the replacer array are
            stringified.

            Values that do not have JSON representations, such as undefined or
            functions, will not be serialized. Such values in objects will be
            dropped; in arrays they will be replaced with null. You can use
            a replacer function to replace those with JSON values.
            JSON.stringify(undefined) returns undefined.

            The optional space parameter produces a stringification of the
            value that is filled with line breaks and indentation to make it
            easier to read.

            If the space parameter is a non-empty string, then that string will
            be used for indentation. If the space parameter is a number, then
            the indentation will be that many spaces.

            Example:

            text = JSON.stringify(['e', {pluribus: 'unum'}]);
            // text is '["e",{"pluribus":"unum"}]'


            text = JSON.stringify(['e', {pluribus: 'unum'}], null, '\t');
            // text is '[\n\t"e",\n\t{\n\t\t"pluribus": "unum"\n\t}\n]'

            text = JSON.stringify([new Date()], function (key, value) {
                return this[key] instanceof Date ?
                    'Date(' + this[key] + ')' : value;
            });
            // text is '["Date(---current time---)"]'


        JSON.parse(text, reviver)
            This method parses a JSON text to produce an object or array.
            It can throw a SyntaxError exception.

            The optional reviver parameter is a function that can filter and
            transform the results. It receives each of the keys and values,
            and its return value is used instead of the original value.
            If it returns what it received, then the structure is not modified.
            If it returns undefined then the member is deleted.

            Example:

            // Parse the text. Values that look like ISO date strings will
            // be converted to Date objects.

            myData = JSON.parse(text, function (key, value) {
                var a;
                if (typeof value === 'string') {
                    a =
/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}(?:\.\d*)?)Z$/.exec(value);
                    if (a) {
                        return new Date(Date.UTC(+a[1], +a[2] - 1, +a[3], +a[4],
                            +a[5], +a[6]));
                    }
                }
                return value;
            });

            myData = JSON.parse('["Date(09/09/2001)"]', function (key, value) {
                var d;
                if (typeof value === 'string' &&
                        value.slice(0, 5) === 'Date(' &&
                        value.slice(-1) === ')') {
                    d = new Date(value.slice(5, -1));
                    if (d) {
                        return d;
                    }
                }
                return value;
            });


    This is a reference implementation. You are free to copy, modify, or
    redistribute.
*/

/*jslint evil: true, regexp: true */

/*members "", "\b", "\t", "\n", "\f", "\r", "\"", JSON, "\\", apply,
    call, charCodeAt, getUTCDate, getUTCFullYear, getUTCHours,
    getUTCMinutes, getUTCMonth, getUTCSeconds, hasOwnProperty, join,
    lastIndex, length, parse, prototype, push, replace, slice, stringify,
    test, toJSON, toString, valueOf
*/


// Create a JSON object only if one does not already exist. We create the
// methods in a closure to avoid creating global variables.

if (typeof JSON !== 'object') {
    JSON = {};
}

(function () {
    'use strict';

    function f(n) {
        // Format integers to have at least two digits.
        return n < 10 ? '0' + n : n;
    }

    if (typeof Date.prototype.toJSON !== 'function') {

        Date.prototype.toJSON = function (key) {

            return isFinite(this.valueOf())
                ? this.getUTCFullYear()     + '-' +
                    f(this.getUTCMonth() + 1) + '-' +
                    f(this.getUTCDate())      + 'T' +
                    f(this.getUTCHours())     + ':' +
                    f(this.getUTCMinutes())   + ':' +
                    f(this.getUTCSeconds())   + 'Z'
                : null;
        };

        String.prototype.toJSON      =
            Number.prototype.toJSON  =
            Boolean.prototype.toJSON = function (key) {
                return this.valueOf();
            };
    }

    var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        gap,
        indent,
        meta = {    // table of character substitutions
            '\b': '\\b',
            '\t': '\\t',
            '\n': '\\n',
            '\f': '\\f',
            '\r': '\\r',
            '"' : '\\"',
            '\\': '\\\\'
        },
        rep;


    function quote(string) {

// If the string contains no control characters, no quote characters, and no
// backslash characters, then we can safely slap some quotes around it.
// Otherwise we must also replace the offending characters with safe escape
// sequences.

        escapable.lastIndex = 0;
        return escapable.test(string) ? '"' + string.replace(escapable, function (a) {
            var c = meta[a];
            return typeof c === 'string'
                ? c
                : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
        }) + '"' : '"' + string + '"';
    }


    function str(key, holder) {

// Produce a string from holder[key].

        var i,          // The loop counter.
            k,          // The member key.
            v,          // The member value.
            length,
            mind = gap,
            partial,
            value = holder[key];

// If the value has a toJSON method, call it to obtain a replacement value.

        if (value && typeof value === 'object' &&
                typeof value.toJSON === 'function') {
            value = value.toJSON(key);
        }

// If we were called with a replacer function, then call the replacer to
// obtain a replacement value.

        if (typeof rep === 'function') {
            value = rep.call(holder, key, value);
        }

// What happens next depends on the value's type.

        switch (typeof value) {
        case 'string':
            return quote(value);

        case 'number':

// JSON numbers must be finite. Encode non-finite numbers as null.

            return isFinite(value) ? String(value) : 'null';

        case 'boolean':
        case 'null':

// If the value is a boolean or null, convert it to a string. Note:
// typeof null does not produce 'null'. The case is included here in
// the remote chance that this gets fixed someday.

            return String(value);

// If the type is 'object', we might be dealing with an object or an array or
// null.

        case 'object':

// Due to a specification blunder in ECMAScript, typeof null is 'object',
// so watch out for that case.

            if (!value) {
                return 'null';
            }

// Make an array to hold the partial results of stringifying this object value.

            gap += indent;
            partial = [];

// Is the value an array?

            if (Object.prototype.toString.apply(value) === '[object Array]') {

// The value is an array. Stringify every element. Use null as a placeholder
// for non-JSON values.

                length = value.length;
                for (i = 0; i < length; i += 1) {
                    partial[i] = str(i, value) || 'null';
                }

// Join all of the elements together, separated with commas, and wrap them in
// brackets.

                v = partial.length === 0
                    ? '[]'
                    : gap
                    ? '[\n' + gap + partial.join(',\n' + gap) + '\n' + mind + ']'
                    : '[' + partial.join(',') + ']';
                gap = mind;
                return v;
            }

// If the replacer is an array, use it to select the members to be stringified.

            if (rep && typeof rep === 'object') {
                length = rep.length;
                for (i = 0; i < length; i += 1) {
                    if (typeof rep[i] === 'string') {
                        k = rep[i];
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
            } else {

// Otherwise, iterate through all of the keys in the object.

                for (k in value) {
                    if (Object.prototype.hasOwnProperty.call(value, k)) {
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
            }

// Join all of the member texts together, separated with commas,
// and wrap them in braces.

            v = partial.length === 0
                ? '{}'
                : gap
                ? '{\n' + gap + partial.join(',\n' + gap) + '\n' + mind + '}'
                : '{' + partial.join(',') + '}';
            gap = mind;
            return v;
        }
    }

// If the JSON object does not yet have a stringify method, give it one.

    if (typeof JSON.stringify !== 'function') {
        JSON.stringify = function (value, replacer, space) {

// The stringify method takes a value and an optional replacer, and an optional
// space parameter, and returns a JSON text. The replacer can be a function
// that can replace values, or an array of strings that will select the keys.
// A default replacer method can be provided. Use of the space parameter can
// produce text that is more easily readable.

            var i;
            gap = '';
            indent = '';

// If the space parameter is a number, make an indent string containing that
// many spaces.

            if (typeof space === 'number') {
                for (i = 0; i < space; i += 1) {
                    indent += ' ';
                }

// If the space parameter is a string, it will be used as the indent string.

            } else if (typeof space === 'string') {
                indent = space;
            }

// If there is a replacer, it must be a function or an array.
// Otherwise, throw an error.

            rep = replacer;
            if (replacer && typeof replacer !== 'function' &&
                    (typeof replacer !== 'object' ||
                    typeof replacer.length !== 'number')) {
                throw new Error('JSON.stringify');
            }

// Make a fake root object containing our value under the key of ''.
// Return the result of stringifying the value.

            return str('', {'': value});
        };
    }


// If the JSON object does not yet have a parse method, give it one.

    if (typeof JSON.parse !== 'function') {
        JSON.parse = function (text, reviver) {

// The parse method takes a text and an optional reviver function, and returns
// a JavaScript value if the text is a valid JSON text.

            var j;

            function walk(holder, key) {

// The walk method is used to recursively walk the resulting structure so
// that modifications can be made.

                var k, v, value = holder[key];
                if (value && typeof value === 'object') {
                    for (k in value) {
                        if (Object.prototype.hasOwnProperty.call(value, k)) {
                            v = walk(value, k);
                            if (v !== undefined) {
                                value[k] = v;
                            } else {
                                delete value[k];
                            }
                        }
                    }
                }
                return reviver.call(holder, key, value);
            }


// Parsing happens in four stages. In the first stage, we replace certain
// Unicode characters with escape sequences. JavaScript handles many characters
// incorrectly, either silently deleting them, or treating them as line endings.

            text = String(text);
            cx.lastIndex = 0;
            if (cx.test(text)) {
                text = text.replace(cx, function (a) {
                    return '\\u' +
                        ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                });
            }

// In the second stage, we run the text against regular expressions that look
// for non-JSON patterns. We are especially concerned with '()' and 'new'
// because they can cause invocation, and '=' because it can cause mutation.
// But just to be safe, we want to reject all unexpected forms.

// We split the second stage into 4 regexp operations in order to work around
// crippling inefficiencies in IE's and Safari's regexp engines. First we
// replace the JSON backslash pairs with '@' (a non-JSON character). Second, we
// replace all simple value tokens with ']' characters. Third, we delete all
// open brackets that follow a colon or comma or that begin the text. Finally,
// we look to see that the remaining characters are only whitespace or ']' or
// ',' or ':' or '{' or '}'. If that is so, then the text is safe for eval.

            if (/^[\],:{}\s]*$/
                    .test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@')
                        .replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']')
                        .replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) {

// In the third stage we use the eval function to compile the text into a
// JavaScript structure. The '{' operator is subject to a syntactic ambiguity
// in JavaScript: it can begin a block or an object literal. We wrap the text
// in parens to eliminate the ambiguity.

                j = eval('(' + text + ')');

// In the optional fourth stage, we recursively walk the new structure, passing
// each name/value pair to a reviver function for possible transformation.

                return typeof reviver === 'function'
                    ? walk({'': j}, '')
                    : j;
            }

// If the text is not JSON parseable, then a SyntaxError is thrown.

            throw new SyntaxError('JSON.parse');
        };
    }
}());






/*! Overthrow v.0.1.0. An overflow:auto polyfill for responsive design. (c) 2012: Scott Jehl, Filament Group, Inc. http://filamentgroup.github.com/Overthrow/license.txt */
(function( w, undefined ){
    
    var doc = w.document,
        docElem = doc.documentElement,
        classtext = "overthrow-enabled",
    
        // Touch events are used in the polyfill, and thus are a prerequisite
        canBeFilledWithPoly = "ontouchmove" in doc,
        
        // The following attempts to determine whether the browser has native overflow support
        // so we can enable it but not polyfill
        overflowProbablyAlreadyWorks =
            // Features-first. iOS5 overflow scrolling property check - no UA needed here. thanks Apple :)
            "WebkitOverflowScrolling" in docElem.style ||
            // Touch events aren't supported and screen width is greater than X
            // ...basically, this is a loose "desktop browser" check. 
            // It may wrongly opt-in very large tablets with no touch support.
            ( !canBeFilledWithPoly && w.screen.width > 1200 ) ||
            // Hang on to your hats.
            // Whitelist some popular, overflow-supporting mobile browsers for now and the future
            // These browsers are known to get overlow support right, but give us no way of detecting it.
            (function(){
                var ua = w.navigator.userAgent,
                    // Webkit crosses platforms, and the browsers on our list run at least version 534
                    webkit = ua.match( /AppleWebKit\/([0-9]+)/ ),
                    wkversion = webkit && webkit[1],
                    wkLte534 = webkit && wkversion >= 534;

                return (
                    /* Android 3+ with webkit gte 534
                    ~: Mozilla/5.0 (Linux; U; Android 3.0; en-us; Xoom Build/HRI39) AppleWebKit/534.13 (KHTML, like Gecko) Version/4.0 Safari/534.13 */
                    ua.match( /Android ([0-9]+)/ ) && RegExp.$1 >= 3 && wkLte534 ||
                    /* Blackberry 7+ with webkit gte 534
                    ~: Mozilla/5.0 (BlackBerry; U; BlackBerry 9900; en-US) AppleWebKit/534.11+ (KHTML, like Gecko) Version/7.0.0 Mobile Safari/534.11+ */
                    ua.match( / Version\/([0-9]+)/ ) && RegExp.$1 >= 0 && w.blackberry && wkLte534 ||
                    /* Blackberry Playbook with webkit gte 534
                    ~: Mozilla/5.0 (PlayBook; U; RIM Tablet OS 1.0.0; en-US) AppleWebKit/534.8+ (KHTML, like Gecko) Version/0.0.1 Safari/534.8+ */   
                    ua.indexOf( /PlayBook/ ) > -1 && RegExp.$1 >= 0 && wkLte534 ||
                    /* Firefox Mobile (Fennec) 4 and up
                    ~: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.7; rv:2.1.1) Gecko/ Firefox/4.0.2pre Fennec/4.0. */
                    ua.match( /Fennec\/([0-9]+)/ ) && RegExp.$1 >= 4 ||
                    /* WebOS 3 and up (TouchPad too)
                    ~: Mozilla/5.0 (hp-tablet; Linux; hpwOS/3.0.0; U; en-US) AppleWebKit/534.6 (KHTML, like Gecko) wOSBrowser/233.48 Safari/534.6 TouchPad/1.0 */
                    ua.match( /wOSBrowser\/([0-9]+)/ ) && RegExp.$1 >= 233 && wkLte534 ||
                    /* Nokia Browser N8
                    ~: Mozilla/5.0 (Symbian/3; Series60/5.2 NokiaN8-00/012.002; Profile/MIDP-2.1 Configuration/CLDC-1.1 ) AppleWebKit/533.4 (KHTML, like Gecko) NokiaBrowser/7.3.0 Mobile Safari/533.4 3gpp-gba 
                    ~: Note: the N9 doesn't have native overflow with one-finger touch. wtf */
                    ua.match( /NokiaBrowser\/([0-9\.]+)/ ) && parseFloat(RegExp.$1) === 7.3 && webkit && wkversion >= 533 ||
                    /* Windows Phone 8 */
                    ua.match( /IEMobile\/([0-9]+)/ ) && RegExp.$1 >= 10
                );
            })(),
    
        // Easing can use any of Robert Penner's equations (http://www.robertpenner.com/easing_terms_of_use.html). By default, overthrow includes ease-out-cubic
        // arguments: t = current iteration, b = initial value, c = end value, d = total iterations
        // use w.overthrow.easing to provide a custom function externally, or pass an easing function as a callback to the toss method
        defaultEasing = function (t, b, c, d) {
            return c*((t=t/d-1)*t*t + 1) + b;
        },  
            
        enabled = false,
        
        // Keeper of intervals
        timeKeeper,
                
        /* toss scrolls and element with easing
        
        // elem is the element to scroll
        // options hash:
            * left is the desired horizontal scroll. Default is "+0". For relative distances, pass a string with "+" or "-" in front.
            * top is the desired vertical scroll. Default is "+0". For relative distances, pass a string with "+" or "-" in front.
            * duration is the number of milliseconds the throw will take. Default is 100.
            * easing is an optional custom easing function. Default is w.overthrow.easing. Must follow the easing function signature 
        */
        toss = function( elem, options ){
            var i = 0,
                sLeft = elem.scrollLeft,
                sTop = elem.scrollTop,
                // Toss defaults
                o = {
                    top: "+0",
                    left: "+0",
                    duration: 100,
                    easing: w.overthrow.easing
                },
                endLeft, endTop;
            
            // Mixin based on predefined defaults
            if( options ){
                for( var j in o ){
                    if( options[ j ] !== undefined ){
                        o[ j ] = options[ j ];
                    }
                }
            }
            
            // Convert relative values to ints
            // First the left val
            if( typeof o.left === "string" ){
                o.left = parseFloat( o.left );
                endLeft = o.left + sLeft;
            }
            else {
                endLeft = o.left;
                o.left = o.left - sLeft;
            }
            // Then the top val
            if( typeof o.top === "string" ){
                o.top = parseFloat( o.top );
                endTop = o.top + sTop;
            }
            else {
                endTop = o.top;
                o.top = o.top - sTop;
            }

            timeKeeper = setInterval(function(){                    
                if( i++ < o.duration ){
                    elem.scrollLeft = o.easing( i, sLeft, o.left, o.duration );
                    elem.scrollTop = o.easing( i, sTop, o.top, o.duration );
                }
                else{
                    if( endLeft !== elem.scrollLeft ){
                        elem.scrollLeft = endLeft;
                    }
                    if( endTop !== elem.scrollTop ){
                        elem.scrollTop = endTop;
                    }
                    intercept();
                }
            }, 1 );
            
            // Return the values, post-mixin, with end values specified
            return { top: endTop, left: endLeft, duration: o.duration, easing: o.easing };
        },
        
        // find closest overthrow (elem or a parent)
        closest = function( target, ascend ){
            return !ascend && target.className && target.className.indexOf( "overthrow" ) > -1 && target || closest( target.parentNode );
        },
                
        // Intercept any throw in progress
        intercept = function(){
            clearInterval( timeKeeper );
        },
            
        // Enable and potentially polyfill overflow
        enable = function(){
                
            // If it's on, 
            if( enabled ){
                return;
            }
            // It's on.
            enabled = true;
                
            // If overflowProbablyAlreadyWorks or at least the element canBeFilledWithPoly, add a class to cue CSS that assumes overflow scrolling will work (setting height on elements and such)
            if( overflowProbablyAlreadyWorks || canBeFilledWithPoly ){
                docElem.className += " " + classtext;
            }
                
            // Destroy everything later. If you want to.
            w.overthrow.forget = function(){
                // Strip the class name from docElem
                docElem.className = docElem.className.replace( classtext, "" );
                // Remove touch binding (check for method support since this part isn't qualified by touch support like the rest)
                if( doc.removeEventListener ){
                    doc.removeEventListener( "touchstart", start, false );
                }
                // reset easing to default
                w.overthrow.easing = defaultEasing;
                
                // Let 'em know
                enabled = false;
            };
    
            // If overflowProbablyAlreadyWorks or it doesn't look like the browser canBeFilledWithPoly, our job is done here. Exit viewport left.
            if( overflowProbablyAlreadyWorks || !canBeFilledWithPoly ){
                return;
            }

            // Fill 'er up!
            // From here down, all logic is associated with touch scroll handling
                // elem references the overthrow element in use
            var elem,
                
                // The last several Y values are kept here
                lastTops = [],
        
                // The last several X values are kept here
                lastLefts = [],
                
                // lastDown will be true if the last scroll direction was down, false if it was up
                lastDown,
                
                // lastRight will be true if the last scroll direction was right, false if it was left
                lastRight,
                
                // For a new gesture, or change in direction, reset the values from last scroll
                resetVertTracking = function(){
                    lastTops = [];
                    lastDown = null;
                },
                
                resetHorTracking = function(){
                    lastLefts = [];
                    lastRight = null;
                },
                
                // After releasing touchend, throw the overthrow element, depending on momentum
                finishScroll = function(){
                    // Come up with a distance and duration based on how 
                    // Multipliers are tweaked to a comfortable balance across platforms
                    var top = ( lastTops[ 0 ] - lastTops[ lastTops.length -1 ] ) * 8,
                        left = ( lastLefts[ 0 ] - lastLefts[ lastLefts.length -1 ] ) * 8,
                        duration = Math.max( Math.abs( left ), Math.abs( top ) ) / 8;
                    
                    // Make top and left relative-style strings (positive vals need "+" prefix)
                    top = ( top > 0 ? "+" : "" ) + top;
                    left = ( left > 0 ? "+" : "" ) + left;
                    
                    // Make sure there's a significant amount of throw involved, otherwise, just stay still
                    if( !isNaN( duration ) && duration > 0 && ( Math.abs( left ) > 80 || Math.abs( top ) > 80 ) ){
                        toss( elem, { left: left, top: top, duration: duration } );
                    }
                },
            
                // On webkit, touch events hardly trickle through textareas and inputs
                // Disabling CSS pointer events makes sure they do, but it also makes the controls innaccessible
                // Toggling pointer events at the right moments seems to do the trick
                // Thanks Thomas Bachem http://stackoverflow.com/a/5798681 for the following
                inputs,
                setPointers = function( val ){
                    inputs = elem.querySelectorAll( "textarea, input" );
                    for( var i = 0, il = inputs.length; i < il; i++ ) {
                        inputs[ i ].style.pointerEvents = val;
                    }
                },
                
                // For nested overthrows, changeScrollTarget restarts a touch event cycle on a parent or child overthrow
                changeScrollTarget = function( startEvent, ascend ){
                    if( doc.createEvent ){
                        var newTarget = ( !ascend || ascend === undefined ) && elem.parentNode || elem.touchchild || elem,
                            tEnd;
                                
                        if( newTarget !== elem ){
                            tEnd = doc.createEvent( "HTMLEvents" );
                            tEnd.initEvent( "touchend", true, true );
                            elem.dispatchEvent( tEnd );
                            newTarget.touchchild = elem;
                            elem = newTarget;
                            newTarget.dispatchEvent( startEvent );
                        }
                    }
                },
                
                // Touchstart handler
                // On touchstart, touchmove and touchend are freshly bound, and all three share a bunch of vars set by touchstart
                // Touchend unbinds them again, until next time
                start = function( e ){
                    
                    // Stop any throw in progress
                    intercept();
                    
                    // Reset the distance and direction tracking
                    resetVertTracking();
                    resetHorTracking();
                        
                    elem = closest( e.target );
                        
                    if( !elem || elem === docElem || e.touches.length > 1 ){
                        return;
                    }           

                    setPointers( "none" );
                    var touchStartE = e,
                        scrollT = elem.scrollTop,
                        scrollL = elem.scrollLeft,
                        height = elem.offsetHeight,
                        width = elem.offsetWidth,
                        startY = e.touches[ 0 ].pageY,
                        startX = e.touches[ 0 ].pageX,
                        scrollHeight = elem.scrollHeight,
                        scrollWidth = elem.scrollWidth,
                    
                        // Touchmove handler
                        move = function( e ){
                        
                            var ty = scrollT + startY - e.touches[ 0 ].pageY,
                                tx = scrollL + startX - e.touches[ 0 ].pageX,
                                down = ty >= ( lastTops.length ? lastTops[ 0 ] : 0 ),
                                right = tx >= ( lastLefts.length ? lastLefts[ 0 ] : 0 );
                                
                            // If there's room to scroll the current container, prevent the default window scroll
                            if( ( ty > 0 && ty < scrollHeight - height ) || ( tx > 0 && tx < scrollWidth - width ) ){
                                e.preventDefault();
                            }
                            // This bubbling is dumb. Needs a rethink.
                            else {
                                changeScrollTarget( touchStartE );
                            }
                            
                            // If down and lastDown are inequal, the y scroll has changed direction. Reset tracking.
                            if( lastDown && down !== lastDown ){
                                resetVertTracking();
                            }
                            
                            // If right and lastRight are inequal, the x scroll has changed direction. Reset tracking.
                            if( lastRight && right !== lastRight ){
                                resetHorTracking();
                            }
                            
                            // remember the last direction in which we were headed
                            lastDown = down;
                            lastRight = right;                          
                            
                            // set the container's scroll
                            elem.scrollTop = ty;
                            elem.scrollLeft = tx;
                        
                            lastTops.unshift( ty );
                            lastLefts.unshift( tx );
                        
                            if( lastTops.length > 3 ){
                                lastTops.pop();
                            }
                            if( lastLefts.length > 3 ){
                                lastLefts.pop();
                            }
                        },
                    
                        // Touchend handler
                        end = function( e ){
                            // Apply momentum based easing for a graceful finish
                            finishScroll(); 
                            // Bring the pointers back
                            setPointers( "auto" );
                            setTimeout( function(){
                                setPointers( "none" );
                            }, 450 );
                            elem.removeEventListener( "touchmove", move, false );
                            elem.removeEventListener( "touchend", end, false );
                        };
                    
                    elem.addEventListener( "touchmove", move, false );
                    elem.addEventListener( "touchend", end, false );
                };
                
            // Bind to touch, handle move and end within
            doc.addEventListener( "touchstart", start, false );
        };
        
    // Expose overthrow API
    w.overthrow = {
        set: enable,
        forget: function(){},
        easing: defaultEasing,
        toss: toss,
        intercept: intercept,
        closest: closest,
        support: overflowProbablyAlreadyWorks ? "native" : canBeFilledWithPoly && "polyfilled" || "none"
    };
    
    // Auto-init
    enable();
        
})( this );