var fromCurrencySelect = document.querySelector("#fromCurrencySelect"),
    toCurrencySelect = document.querySelector("#toCurrencySelect"),
    options,
    selectedFromCurrency,
    selectedToCurrency,
    setFromCurrency = function (currencyCode){
      document.querySelector("#fromCurrencyCode").innerHTML = currencyCode;
      selectedFromCurrency = currencyCode;
    },
    setToCurrency = function (currencyCode){
      document.querySelector("#toCurrencyCode").innerHTML = currencyCode;
      selectedToCurrency = currencyCode;
    }
    getConvertedCurrency = function(){
      try{
        var amount = document.getElementById("currencyAmount").value,
            url = "http://devel.farebookings.com/api/curconversor/" + selectedFromCurrency +
                   "/" + selectedToCurrency +"/" + amount + "/json";                   
         
            var xhr = new XMLHttpRequest({mozSystem: true});

            // test url: http://robnyman.github.com/Firefox-OS-Boilerplate-App/README.md
            xhr.open("GET", url, true);

            xhr.onreadystatechange = function () {
                if (xhr.status === 200 && xhr.readyState === 4) {
                  var result = xhr.response.split("\"");
                
                  document.querySelector(".result").innerHTML = result[3];
                }
            }

            xhr.onerror = function () {
                console.log(xhr.status);
                console.log(xhr.response);
            };
            
            xhr.send(null);

      }catch(err){
        console.log(err);
      }
    },
    currencySelectChange = function (selectedItem, isFromCurrency){
      var selectedValue = selectedItem.options[selectedItem.selectedIndex].value;

      if(isFromCurrency){
        setFromCurrency(selectedValue);
      }else{
        setToCurrency(selectedValue);
      }
    },
    initCurrenciesSelect = function (){
      var currenciesLength = currencies.length,
          index;

      for(var index = 0; index < currenciesLength; index++){
            var keyAndValue = currencies[index].currencyKey + " - " + currencies[index].currencyName;
            options += "<option value=" + currencies[index].currencyKey + ">" + keyAndValue + "</option>";
        }

        fromCurrencySelect.innerHTML = options;
        toCurrencySelect.innerHTML = options;

        setFromCurrency("EUR");
        setToCurrency("HUF");
    },
    init = function (){
      initCurrenciesSelect();
    };

document.querySelector('#fromCurrencySelect').addEventListener ('change', function () {
  currencySelectChange(fromCurrencySelect, true);
});

document.querySelector('#toCurrencySelect').addEventListener ('change', function () {
  currencySelectChange(toCurrencySelect);
});

document.querySelector('#exchangeButton').addEventListener ('click', function () {
  getConvertedCurrency();
});

document.querySelector('#btn-lists').addEventListener ('click', function () {
  document.querySelector('#lists').className = 'current';
  document.querySelector('[data-position="current"]').className = 'left';
});
document.querySelector('#btn-lists-back').addEventListener ('click', function () {
  document.querySelector('#lists').className = 'right';
  document.querySelector('[data-position="current"]').className = 'current';
});

document.querySelector('#btnFromCurrency').addEventListener ('click', function () {
  document.querySelector('#fromCurrency').className = 'current';
  document.querySelector('[data-position="current"]').className = 'left';
});
document.querySelector('#btnFromCurrencyBack').addEventListener ('click', function () {
  document.querySelector('#fromCurrency').className = 'right';
  document.querySelector('[data-position="current"]').className = 'current';
});


document.querySelector('#btnToCurrency').addEventListener ('click', function () {
  document.querySelector('#toCurrency').className = 'current';
  document.querySelector('[data-position="current"]').className = 'left';
});
document.querySelector('#btnToCurrencyBack').addEventListener ('click', function () {
  document.querySelector('#toCurrency').className = 'right';
  document.querySelector('[data-position="current"]').className = 'current';
});

!(function(){
  init();
})();
