'use strict';

angular.module('seetiesApp')
    .controller('TopbarCtrl', function ($scope, $location, $http, SearchQuery) {
        $scope.data = SearchQuery;

        $scope.isRuta = function (ruta) {
            return $location.path().substring(1, 1 + ruta.length) == ruta;
        };

        $scope.historyBack = function () {
            if (window.history.length > 1) window.history.back();
            else $location.path("/");
        };

        $scope.drawerActivo = false;

        $scope.toggleDrawer = function () {
            $scope.drawerActivo = !$scope.drawerActivo;
        };

        $scope.navegar = function (destino) {
            $location.path(destino);
            $scope.drawerActivo = false;
            $scope.data.mostrarSelector = false;
        };

        $scope.toggleSelector = function () {
            $scope.data.mostrarSelector = !$scope.data.mostrarSelector;
        };

        $scope.ciudadSeleccionada;

        $scope.seleccionarCiudad = function (id) {
            $location.path("/s/" + id);
            $scope.toggleSelector();
        };

        // Mensaje bienvenida
        $scope.dismissBienvenida = localStorage.dismiss == "true" ? true : false;

        $scope.mensajeBienvenida = function (siempre) {
            localStorage.dismiss = siempre;
            $scope.dismissBienvenida = true;
        }
    });
