﻿define([], function () {

    var settingsController = ['$scope', '$location', 'ModelsService', 'Utils', 'SettingsService', 'DataService', '$translate', function ($scope, $location, ModelsService, Utils, SettingsService, DataService, $translate) {
        debug.info("SettingsController entered");

        $scope.langOptions = [
            { value: 'en-US', text: 'English' },
            { value: 'ru-RU', text: 'Russian' }
        ];

        $scope['lang'] = SettingsService.get('lang');

        $scope.changed = function (id) {
            SettingsService.set(id, $scope[id]);
        };

        $scope.langChanged = function () {
            $scope.changed('lang');
            $translate.uses(SettingsService.get('lang'));
            Utils.apply($scope);
        };

        $scope.reset = function () {
            if (!confirm($translate('SET_RESET_CONFIRM'))) return;
            SettingsService.setDefault();
            DataService.connect(function () {
                DataService.clear('Images', function () {
                    DataService.clear('ModelPhotos', function () {
                        DataService.clear('Models', function () {
                            window.location.reload();
                        }, $scope.error);
                    }, $scope.error);
                }, $scope.error);
            });
        };

        $scope.error = function (result) {
            debug.error(result);
            $scope.loading = false;
            $scope.error = true;
        };
    }];

    return settingsController;
});
