﻿define([], function () {
    var directive = ['DataService', function (DataService) {
        debug.info('Cached image directive called...');

        var item = {
            scope: {
                url: '='
            },
            link: function (scope, element, attrs) {

                var url = attrs.mhCachedimage || scope.url;

                scope.$watch('url', function (nv, ov) {
                    if (nv && window.URL) item.checkImage(nv, element, function () {
                        //scope.$emit('masonry.reload');
                        //debug.info('masonry reload');
                    });
                });

                scope.$on('$destroy', function () {
                    URL.revokeObjectURL($(element).attr('src'));
                });

                if (!window.URL || !url) return;
                item.checkImage(url, element, function () {
                   //scope.$emit('masonry.reload');
                   //debug.info('masonry reload');
                });
            },

            checkImage: function (url, element, oncomplete) {
                DataService.connect(function () {
                    DataService.item('Images', url.toLowerCase(), function (buf) {
                        if (buf) {
                            $(element).attr('src', URL.createObjectURL(new Blob([buf])));
                            if (oncomplete) oncomplete();
                            return;
                        }
                        item.cacheImage(url, function (blobUrl) {
                            $(element).attr('src', blobUrl);
                            if (oncomplete) oncomplete();
                        });
                    });
                });
            },

            cacheImage: function (url, onsuccess) {
                var xhr = new XMLHttpRequest();
                var buf;

                xhr.open("GET", url, true);
                xhr.responseType = "arraybuffer";

                xhr.addEventListener("load", function () {
                    if (xhr.status === 200) {
                        buf = xhr.response;
                        DataService.saveItemWithKey('Images', buf, url.toLowerCase(), function () {
                            try {
                                onsuccess(URL.createObjectURL(new Blob(buf)));
                            } catch (e) {
                                onsuccess(url);
                            }
                        });
                    } else {
                        onsuccess(url);
                    }
                }, false);

                xhr.addEventListener("error", function () {
                    onsuccess(url);
                });

                xhr.send();
            }
        };
        return item;
    }];
    return directive;
});