﻿define([], function () {
    var directive = function () {
        debug.info('Indeterminate progress directive called...');

        var item = {
            template: '<div class="progress-xs"><div class="progress-bar progress-bar-warning" style="width: 0%"></div></div>',
            link: function (scope, element) {
                $(element).find('.progress-bar').css('transition', 'none');
                scope.$watch('loading', function (newValue, oldValue) {
                    debug.info('loading changed', newValue);
                    if (!newValue && item.interval) window.clearInterval(item.interval);
                    if (newValue) {
                        item.interval = window.setInterval(function () {
                            item.progress += 1;
                            if (item.progress > 100) item.progress = 0;
                            $(element).find('.progress-bar').css('width', item.progress + '%');
                        }, 60);
                    }
                });
            },
            progress: 0
        };
        return item;
    }
    return directive;
});