﻿define([], function () {
    var directive = ['DataService', 'ModelsService', 'Utils', 'ModelsCatalogService', function (DataService, ModelsService, Utils, ModelsCatalogService) {
        debug.info('Model photo directive called...');

        var item = {
            template: '<img mh-imgerr="images/default.png" url="photo.Host + photo.T" mh-cachedimage="{{ photo.Host }}{{ photo.T }}" src="images/default.png"><a ng-href="#/models/{{ Utils.modelUrl(model) }}"></a>'
                + '<div class="desc">'
                    + '<h4>{{ model.DisplayName }}</h4>'
                    + '<p>{{ Catalog.countryName(model.CountryCode) }}</p>'
                    + '<span>{{ Utils.dateFromSec(model.Created)}}</span>'
                + '</div>',
            link: function (scope, element, attrs) {

                scope.itemNumber = parseInt(attrs.mhModelphoto);
                
                scope.Utils = Utils;
                scope.Catalog = ModelsCatalogService;

                
            },
            scope: {
                photoid: '='
            },
            controller: function ($scope) {
                
                if (!$scope.photoid) return;

                ModelsService.modelPhoto($scope.photoid, function (photo) {
                    $scope.photo = photo;
                    ModelsService.model(photo.ModelId, function (model) {
                        $scope.model = model;
                        Utils.apply($scope);
                    });
                });

            }
        };
        return item;
    }];
    return directive;
});