﻿define([
    'directives/Header'
    , 'directives/Menu'
    , 'directives/IndeterminateProgress'
    , 'directives/ImageError'
    , 'directives/ButtonLoading'
    , 'directives/PhotoSwipe'
    , 'directives/CachedImage'
    , 'directives/ModelPhoto'
], function (header, menu, ip, ierr, blo, ps, ci, mp) {

    var directives = {
        Header: header,
        Menu: menu,
        Iprogress: ip,
        Imgerr: ierr,
        Bloading: blo,
        Photoswipe: ps,
        Cachedimage: ci,
        Modelphoto: mp 
    };
    
    var initialize = function (app) {

        _.each(directives, function (directive, name) {
            app.directive('mh' + name, directive);
        })

        debug.info("Registered Directives: ", directives);
    };

    return {
        initialize: initialize
    };

});