﻿define([], function () {

    debug.info("Entering ModelsCatalogService module.");

    var service = ['$http', 'SettingsService', 'DataService', 'Utils', function ($http, SettingsService, DataService, Utils) {

        var self = this;
        self.localeMapping = [{ name: 'ru-RU', locale: 1049 }];
        self.chb = SettingsService.get('catalogHandbook');
                
        self.imageSectionName = function (id) {
            var imageSection = self.findCHBItem('ImageSections', 'Id', id);
            return imageSection ? self.localizedName(imageSection) : null;
        }

        self.imageSectionUrlName = function (id) {
            var imageSection = self.findCHBItem('ImageSections', 'Id', id);
            return imageSection ? Utils.urlName(imageSection.Name) : null;
        }

        self.imageSectionFromUrl = function (urlName) {
            var imageSection = null;

            var coll = self.chb['ImageSections'];
            for (var i = 0 ; i < coll.length; i++) {
                var item = coll[i];
                if (Utils.urlName(item['Name']) == urlName) {
                    imageSection = item;
                    break;
                }
            }
            return imageSection ? imageSection : null;
        }

        self.countryName = function (code) {
            var country = self.findCHBItem('Countries', 'Code', code);
            return country ? self.localizedName(country) : null;
        }

        self.workAreaName = function (id) {
            var wa = self.findCHBItem('WorkAreas', 'Id', id);
            return wa ? self.localizedName(wa) : null;
        }

        self.travelAvailabilityName = function (id) {
            var wa = self.findCHBItem('TravelAvailabilities', 'Id', id);
            return wa ? self.localizedName(wa) : null;
        }

        self.languageName = function (id) {
            var wa = self.findCHBItem('Languages', 'Id', id);
            return wa ? self.localizedName(wa) : null;
        }

        self.talentName = function (id) {
            var wa = self.findCHBItem('Talents', 'Id', id);
            return wa ? self.localizedName(wa) : null;
        }

        self.findCHBItem = function (collection, field, value) {
            var coll = self.chb[collection];
            for (var i = 0 ; i < coll.length; i++) {
                var item = coll[i];
                if (item[field] == value) return item;
            }
            return null;
        }

        self.localizedName = function (obj) {
            var currentLocale = self.getCurrentLocale();
            if (!currentLocale) return obj.Name;

            for (var i = 0; i < obj.Localizations.length; i++) {
                if (obj.Localizations[i].CultureId == currentLocale) {
                    return obj.Localizations[i].Name;
                }
            }
            return obj.Name;
        }

        self.getCurrentLocale = function () {
            var lang = SettingsService.get('lang');
            if (!lang) return null;
            for (var i = 0; i < self.localeMapping.length; i++) {
                if (self.localeMapping[i].name == lang) return self.localeMapping[i].locale;
            }
            return null;
        }
        return self;
    }];

    return service;
});