﻿define([], function () {

    debug.info("Entering ModelsService module.");

    var service = ['$http', 'SettingsService', 'DataService', function ($http, SettingsService, DataService) {

        var self = this;

        self.serverUrl = SettingsService.get('serverUrl');

        self.state = {};

        self._modelsFromServer = function (page, count, onsuccess, onerror) {
            debug.info('Getting models list from server. Page ' + page + ', Count ' + count);
            $http({ method: 'GET', url: self.serverUrl + '/API/Models?page=' + page + '&count=' + count + '&key=' + SettingsService.get('key') + '&culture=' + SettingsService.get('culture') }).success(function (result) {
                if (onsuccess) onsuccess(result);
            }).error(function (data, status, headers, config) {
                if (onerror) onerror(data);
            });
        };

        self._modelsSearchFromServer = function (query, page, count, onsuccess, onerror) {
            debug.info('Searching models on server. Page ' + page + ', Count ' + count);
            $http({ method: 'GET', url: self.serverUrl + '/API/Search?query='+ query +'&page=' + page + '&count=' + count + '&key=' + SettingsService.get('key') + '&culture=' + SettingsService.get('culture') }).success(function (result) {
                if (onsuccess) onsuccess(result);
            }).error(function (data, status, headers, config) {
                if (onerror) onerror(data);
            });
        };

        self._modelsFromDB = function (before, count, onsuccess, onerror) {
            var loaded = 0;
            debug.info('Getting models list from db. Before ' + new Date(before * 1000) + ', Count ' + count);
            DataService.getModelsBefore(before, function (cursor) {
                if (cursor && cursor.value && loaded < count) {
                    onsuccess(cursor.value);
                    loaded++;
                    cursor.continue();
                } else {
                    onsuccess();
                }
            }, onerror);
        };

        self.models = function (page, count, onsuccess, onerror) {
            self._modelsFromServer(page, count, function (result) {
                var processed = [];
                for (var i = 0; i < result.Items.length; i++) {
                    var item = result.Items[i];
                    self.model(item, function (model) {
                        processed.push(model);
                        if (onsuccess) {
                            onsuccess(model);
                            if (processed.length == result.Items.length) onsuccess(null, { CurrentPageIndex: result.CurrentPageIndex, TotalPageCount: result.TotalPageCount });
                        }
                    }, onerror);
                }
            }, onerror);

        };

        self.search = function (query, page, count, onsuccess, onerror) {
            self._modelsSearchFromServer(query, page, count, function (result) {
                var processed = [];
                if (result && result.Items.length) {
                    for (var i = 0; i < result.Items.length; i++) {
                        var item = result.Items[i];
                        self.model(item, function (model) {
                            processed.push(model);
                            if (onsuccess) {
                                onsuccess(model);
                                if (processed.length == result.Items.length) onsuccess(null, { CurrentPageIndex: result.CurrentPageIndex, TotalPageCount: result.TotalPageCount });
                            }
                        }, onerror);
                    }
                } else {
                    if (onsuccess) onsuccess(null, { CurrentPageIndex: result.CurrentPageIndex, TotalPageCount: result.TotalPageCount });
                }
            }, onerror);

        };

        self._processModel = function (arr, onsuccess, onerror) {
            if (arr && arr.length) {
                var item = arr.pop();
                if (arr.length == 0) self._setMinDate(item.Created);
                DataService.saveItem('Models', item, function (e) {
                    if (onsuccess) onsuccess(item);
                    self._processModel(arr, onsuccess, onerror);
                }, onerror);
            } else {
                if (onsuccess) onsuccess();
            }
        };

        self._processModelPhoto = function (arr, onsuccess, onerror) {
            if (arr && arr.length) {
                var item = arr.pop();
                DataService.saveItem('ModelPhotos', item, function (e) {
                    if (onsuccess) onsuccess(item);
                    self._processModelPhoto(arr, onsuccess, onerror);
                }, onerror);
            } else {
                if (onsuccess) onsuccess();
            }
        };

        self._setMinDate = function (created) {
            var minDate = SettingsService.get('minModelDate');
            if (!minDate || minDate > created) {
                SettingsService.set('minModelDate', created);
            }
        };

        self.model = function (id, onsuccess, onerror) {
            DataService.connect(function () {
                DataService.item('Models', parseInt(id), function (item) {
                    if (item) {
                        if (onsuccess) onsuccess(item);
                        return;
                    }
                    self._modelFromServer(id, function (item) {
                        DataService.saveItem('Models', item, function (e) {
                            if (onsuccess) onsuccess(item);
                        }, onerror);
                    }, onerror);
                }, onerror);
            });
        };

        self._modelFromServer = function (id, onsuccess, onerror) {
            debug.info('Getting model ' + id + ' from server.');
            $http({ method: 'GET', url: self.serverUrl + '/API/Model?ItemNumber=' + id + '&key=' + SettingsService.get('key') + '&culture=' + SettingsService.get('culture') }).success(function (result) {
                if (onsuccess) onsuccess(result);
            }).error(function (data, status, headers, config) {
                if (onerror) onerror(data);
            });
        };

        self.modelPhotos = function (model, onsuccess, onerror) {
            DataService.connect(function () {
                var loaded = 0;
                DataService.itemsByIndex('ModelPhotos', 'ModelId', parseInt(model.Id), function (cursor) {
                    if (cursor && cursor.value) {
                        if (onsuccess) onsuccess(cursor.value);
                        loaded++;
                        cursor.continue();
                    } else {
                        if (loaded == model.Photos.length) {
                            onsuccess();
                        } else {
                            self._modelPhotosFromServer(model.Id, function (result) {
                                self._processModelPhoto(result, onsuccess, onerror);
                            }, onerror);
                        }
                    }
                }, onerror);
            });
        };

        self._modelPhotosFromServer = function (modelId, onsuccess, onerror) {
            debug.info('Getting model ' + modelId + ' photos from server.');
            $http({ method: 'GET', url: self.serverUrl + '/API/ModelPhotos?ItemNumber=' + modelId + '&key=' + SettingsService.get('key') + '&culture=' + SettingsService.get('culture') }).success(function (result) {
                if (onsuccess) onsuccess(result);
            }).error(function (data, status, headers, config) {
                if (onerror) onerror(data);
            });
        };

        self.modelPhoto = function (id, onsuccess, onerror) {
            DataService.connect(function () {
                DataService.item('ModelPhotos', parseInt(id), function (item) {
                    if (item) {
                        if (onsuccess) onsuccess(item);
                        return;
                    }
                    self._modelPhotoFromServer(id, function (item) {
                        DataService.saveItem('ModelPhotos', item, function (e) {
                            if (onsuccess) onsuccess(item);
                        }, onerror);
                    }, onerror);
                }, onerror);
            });
        };

        self._modelPhotoFromServer = function (photoId, onsuccess, onerror) {
            debug.info('Getting model photo ' + photoId + ' from server.');
            $http({ method: 'GET', url: self.serverUrl + '/API/ModelPhoto?ItemNumber=' + photoId + '&key=' + SettingsService.get('key') + '&culture=' + SettingsService.get('culture') }).success(function (result) {
                if (onsuccess) onsuccess(result);
            }).error(function (data, status, headers, config) {
                if (onerror) onerror(data);
            });
        };

        self.modelsGalleries = function (onsuccess, onerror) {
            debug.info('Getting models galleries from server.');
            $http({ cache: true, method: 'GET', url: self.serverUrl + '/API/ModelsPhotoGalleries?key=' + SettingsService.get('key') + '&culture=' + SettingsService.get('culture') }).success(function (result) {
                if (onsuccess) onsuccess(result);
            }).error(function (data, status, headers, config) {
                if (onerror) onerror(data);
            });
        }

        self.modelsGallery = function (id, page, count, onsuccess, onerror, cache) {
            debug.info('Getting models gallery id ' + id + ' from server.');
            
            $http({ cache: true, method: 'GET', url: self.serverUrl + '/API/ModelsPhotoGallery?id=' + id + '&page=' + page + '&count=' + count + '&key=' + SettingsService.get('key') + '&culture=' + SettingsService.get('culture') }).success(function (result) {
                if (onsuccess) onsuccess(result);
            }).error(function (data, status, headers, config) {
                if (onerror) onerror(data);
            });
        }

        self.installCatalogData = function (onsuccess, onerror, url) {
            if (!url) url = '/data/catalog-handbook.json';
            $http({ method: 'GET', url: url }).success(function (result) {
                SettingsService.set('catalogHandbook', result);
                if (onsuccess) onsuccess(result);
            }).error(function (data, status, headers, config) {
                if (onerror) onerror(data);
            });
        };

        self.installModelsData = function (onsuccess, onerror) {
            DataService.connect(function () {
                DataService.clear('Models', function () {
                    debug.info('Installing models list from JSON.');
                    $http({ method: 'GET', url: '/data/models.json' }).success(function (result) {
                        self._processModel(result.Items, function (item) {
                            if (!item && onsuccess) onsuccess();
                        }, onerror);
                    }).error(function (data, status, headers, config) {
                        if (onerror) onerror(data);
                    });
                }, onerror);
            });
        }

        self.installModelPhotosData = function (onsuccess, onerror) {
            DataService.connect(function () {
                DataService.clear('ModelPhotos', function () {
                    debug.info('Installing model photos list from JSON.');
                    $http({ method: 'GET', url: '/data/model-photos.json' }).success(function (result) {
                        self._processModelPhoto(result.Items, function (item) {
                            if (!item && onsuccess) onsuccess();
                        }, onerror);
                    }).error(function (data, status, headers, config) {
                        if (onerror) onerror(data);
                    });
                }, onerror);
            });
        }

        return self;
    }];

    return service;
});
