﻿define(['controllers/controllers', 'directives/directives', 'services/services'], function (controllers, directives, services) {

    var initialize = function () {
        debug.info("Running angular application.");

        var mainModule = angular.module('theApp', ['ngRoute', 'ngAnimate', 'pascalprecht.translate', 'ga', 'wu.masonry']);

        mainModule.config(function ($compileProvider) {
            $compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|file|http|app):/);
        });

        mainModule.config(['$translateProvider', function ($translateProvider) {
            $translateProvider.useStaticFilesLoader({
                prefix: '/lang/',
                suffix: '.json'
            });
            $translateProvider.preferredLanguage('en-US');
            $translateProvider.fallbackLanguage('en-US');
        }]);

        controllers.initialize(mainModule);
        directives.initialize(mainModule);
        services.initialize(mainModule);

        angular.bootstrap(window.document, ['theApp']);

        ga('create', 'UA-353735-15', 'auto');

        debug.info("Angular compiled and executed.");
    };

    return {
        initialize: initialize
    };
});
