﻿define(['routes/routes'
    , 'controllers/AppController'
    , 'controllers/InstallController'
    , 'controllers/shared/HeaderController'
    , 'controllers/shared/MenuController'
    , 'controllers/models/ModelsController'
    , 'controllers/models/ModelPortfolioController'
    , 'controllers/models/ModelPortfolioGalleryController'
    , 'controllers/models/ModelPortfolioPropertiesController'
    , 'controllers/models/ModelsPhotoGalleriesController'
    , 'controllers/models/ModelsPhotoGalleryController'
    , 'controllers/SearchController'
    , 'controllers/SettingsController'
    , 'controllers/account/LoginController'
], function (routes, appController, installController, headerController, menuController,
    modelsController, modelPortfolioController, modelPortfolioGalleryController, modelPortfolioPropertiesController,
    modelsPhotoGalleriesController, modelsPhotoGalleryController,
    searchController, settingsController, loginController) {
    
    debug.info("Entering controllers module.");
    
    var controllers = {
        AppController: appController,
        InstallController: installController,
        HeaderController: headerController,
        MenuController: menuController,
        ModelsController: modelsController,
        ModelPortfolioController: modelPortfolioController,
        ModelPortfolioGalleryController: modelPortfolioGalleryController,
        ModelPortfolioPropertiesController: modelPortfolioPropertiesController,
        ModelsPhotoGalleriesController: modelsPhotoGalleriesController,
        ModelsPhotoGalleryController: modelsPhotoGalleryController,
        SearchController: searchController,
        SettingsController: settingsController,
        LoginController: loginController
    };

    var setUpRoutes = function (angModule) {
        // hook up routing
        debug.info('Initializing navigation and routing.', routes);
        angModule.config(function ($routeProvider) {
            _.each(routes, function (value, key) {
                debug.info("Adding " + key + ":", value);
                $routeProvider.when(
                  value.route
                  , {
                      template: value.template
                    , controller: value.controller
                    , title: value.title
                  }
                );
            });
            $routeProvider.otherwise({ redirectTo: routes.Models.route });
        });
        angModule.run(function ($rootScope) {
            $rootScope.$on('$routeChangeSuccess', function (next, last) {
                debug.info("Navigating from / to ", last, next);                
            });
        });
    }

    var initialize = function (angModule) {
        angModule.controller('AppController', appController);

        _.each(controllers, function (controller, name) {
            angModule.controller(name, controller);
        })
        setUpRoutes(angModule);

        debug.info("Registered Controllers: ", controllers);
    };

    return {
        initialize: initialize
    };
});
