﻿define([], function (Console) {

    debug.info("Entering SettingsService module.");

    var service = ["$translate", function ($translate) {

        var self = this;

        self.set = function (name, value) {
            window.localStorage.setItem('Settings:' + name, JSON.stringify(value));
        };

        self.get = function (name) {
            var json = window.localStorage.getItem('Settings:' + name);
            if (json) return JSON.parse(json);
            return null;
        };

        self.setDefault = function () {

            window.localStorage.clear();
            // set defaults here
            self.set('serverUrl', 'http://www.modelhour.com');
            //self.set('serverUrl', 'http://mh.local');
            self.set('key', '0e832fdd-d982-4693-8e22-6562ccaf42ed');
            self.set('modelsPerPage', 20);
            self.set('lang', 'en-US');
            self.set('initialized', true);
        }

        //default settings
        if (!self.get('initialized')) {
            self.setDefault();
        }

        $translate.uses(self.get('lang'));
        return self;
    }];

    return service;
});
