define("appkit/adapters/application",["exports"],function(a){"use strict";a["default"]=DS.RESTAdapter.extend({host:window.ENV.api_url})}),define("appkit/adapters/bookmark",["exports"],function(a){"use strict";var b=DS.LSAdapter.extend({namespace:"cryptsy-app"});a["default"]=b}),define("appkit/app",["resolver","exports"],function(a,b){"use strict";var c=a["default"],d=Ember.Application.extend({LOG_ACTIVE_GENERATION:!0,LOG_MODULE_RESOLVER:!0,LOG_TRANSITIONS:!0,LOG_TRANSITIONS_INTERNAL:!0,LOG_VIEW_LOOKUPS:!0,modulePrefix:"appkit",Resolver:c["default"]});Ember.ControllerMixin.reopen({GLOBAL_APPNAME:"CryptsyT"}),b["default"]=d}),define("appkit/components/pretty-color",["exports"],function(a){"use strict";a["default"]=Ember.Component.extend({classNames:["pretty-color"],attributeBindings:["style"],style:function(){return"color: "+this.get("name")+";"}.property("name")})}),define("appkit/components/template-less",["exports"],function(a){"use strict";a["default"]=Ember.Component.extend({classNames:["look-ma-no-template"],tagName:["span"]})}),define("appkit/controllers/application",["exports"],function(a){"use strict";a["default"]=Ember.Controller.extend({init:function(){},showSidebar:!1,bookmarks:[],onBookmarksChange:function(){window.localStorage.setItem("application.bookmarks",JSON.stringify(this.get("bookmarks")))}.observes("bookmarks.@each")})}),define("appkit/controllers/feedback",["exports"],function(a){"use strict";a["default"]=Ember.Controller.extend({needs:["application"],showSidebar:Ember.computed.alias("controllers.application.showSidebar"),input:null,choices:["Buf","Feature","Opinion","Other"],selectedChoice:null,showThankYouMessage:!1,actions:{submit:function(){var a=this,b=this.get("input");Ember.$.ajax({url:window.ENV.api_url+"/feedbacks",data:{message:b},type:"POST",beforeSend:function(a){a.setRequestHeader("X-CSRF-Token",$('meta[name="csrf-token"]').attr("content"))}}).then(function(){a.set("showThankYouMessage",!0),a.set("input",null)},function(a){alert("Feedback was not sent, because of: "+a.textStatus)})}}})}),define("appkit/controllers/graph",["exports"],function(a){"use strict";function b(a){try{var b=this.value,a=a||"HH:mm";return moment(b).format(a)}catch(c){return this.value}}var c=Ember.Object.create({chart:null,renderToId:null,chartType:null,series:null,categories:null,initialize:function(){var a,c,d;return a={renderTo:this.get("renderToId"),type:this.get("chartType")},d={type:"datetime",categories:this.get("categories"),gridLineWidth:0,tickLength:10,tickInterval:10,labels:{enabled:!0,formatter:b}},c={text:this.get("title")},this.set("chart",a),this.set("xAxis",d),this.set("title",c)},credits:{enabled:!1},colors:["#2f69bf","#a2bf2f","#bf5a2f","#bfa22f","#772fbf","#bf2f2f","#00337f","#657f00","#7f2600","#7f6500"],yAxis:{title:{text:null}},plotOptions:{line:{animation:!1,dataLabels:{enabled:!1},marker:{enabled:!1}}},legend:{enabled:!1},rangeSeletor:{enabled:!0}});a["default"]=Ember.ObjectController.extend({title:null,type:"line",categories:[],data:[],highcharts:null,initGraph:function(a,b,d,e){var f=c,g="line";f.set("chartType",g),f.set("renderToId",a),f.set("series",b),f.set("categories",d),f.set("title",e),f.initialize(),console.log(f);var h=new Highcharts.Chart(f);this.set("highcharts",h)},destroyGraph:function(){this.get("highcharts").destroy()},refresh:function(a,b){console.log("refreshing graph"),this.get("highcharts").series[0].update(a[0]),this.get("highcharts").xAxis[0].update({categories:b}),this.get("highcharts").redraw(),this.get("highcharts").reflow()}})}),define("appkit/controllers/index",["exports"],function(a){"use strict";a["default"]=Ember.ArrayController.extend({needs:["application"],showSidebar:Ember.computed.alias("controllers.application.showSidebar")})}),define("appkit/controllers/market",["exports"],function(a){"use strict";a["default"]=Ember.ObjectController.extend({needs:["application"],showSidebar:Ember.computed.alias("controllers.application.showSidebar"),bookmarks:Ember.computed.alias("controllers.application.bookmarks"),isBookmarked:function(){var a=this.get("model.id"),b=this.get("bookmarks").findBy("id",a);return!!b}.property("controllers.application.bookmarks.@each","model"),cryptsyLink:function(){return"https://www.cryptsy.com/markets/view/"+this.get("marketid")}.property("model")})}),define("appkit/controllers/market/buy",["exports"],function(a){"use strict";a["default"]=Ember.ArrayController.extend({needs:["market"],market:Ember.computed.alias("controllers.market"),sortProperties:["price"],sortAscending:!0,refresh:function(){this.set("content",[]),this.set("content",this.store.find("market_order",{marketid:this.get("market.marketid")}))}})}),define("appkit/controllers/market/sell",["exports"],function(a){"use strict";a["default"]=Ember.ArrayController.extend({needs:["market"],market:Ember.computed.alias("controllers.market"),sortProperties:["price"],sortAscending:!1,refresh:function(){this.set("content",[]),this.set("content",this.store.find("market_order",{marketid:this.get("market.marketid")}))}})}),define("appkit/controllers/market/trades",["exports"],function(a){"use strict";a["default"]=Ember.ArrayController.extend({needs:["market","graph"],market:Ember.computed.alias("controllers.market"),candlesticks:[],refresh:function(){this.set("content",[]),this.set("content",this.store.find("market_trade",{marketid:this.get("market.marketid")}))}})}),define("appkit/controllers/markets",["exports"],function(a){"use strict";a["default"]=Ember.ArrayController.extend({needs:["application"],showSidebar:Ember.computed.alias("controllers.application.showSidebar")})}),define("appkit/helpers/format-datetime",["exports"],function(a){"use strict";a["default"]=Ember.Handlebars.makeBoundHelper(function(a,b){var c="YYYY-MM-DD HH:mm:ss";if(b.hash.format&&(c=b.hash.format),a){var d=moment(a).utc().format(c);return new Handlebars.SafeString('<span class="timestamp">'+d+"</span>")}})}),define("appkit/helpers/format-price",["exports"],function(a){"use strict";a["default"]=Ember.Handlebars.makeBoundHelper(function(a,b){var c=b.hash.decimals||8;return a=Number(a).toFixed(c)})}),define("appkit/helpers/format-value",["exports"],function(a){"use strict";a["default"]=Ember.Handlebars.makeBoundHelper(function(a,b){var c=["currency","number","percent"],d=b.hash.type||"string";if(-1!==c.indexOf(d)){var e=b.hash.decimals||2;switch(a=Number(a).toFixed(e),d){case"currency":a="$"+a;break;case"percent":a+="%"}}else a=a.toString();return a})}),define("appkit/helpers/reverse-word",["exports"],function(a){"use strict";a["default"]=Ember.Handlebars.makeBoundHelper(function(a){return a.split("").reverse().join("")})}),define("appkit/models/bookmark",["exports"],function(a){"use strict";var b=DS.Model.extend({label:DS.attr()});b.FIXTURES=[],a["default"]=b}),define("appkit/models/candlestick",["exports"],function(a){"use strict";a["default"]=DS.Model.extend({marketid:DS.attr("string"),interval_start:DS.attr("date"),interval_end:DS.attr("date"),interval_seconds:DS.attr("number"),open:DS.attr("number"),close:DS.attr("number"),high:DS.attr("number"),low:DS.attr("number"),market:DS.belongsTo("market")})}),define("appkit/models/market",["exports"],function(a){"use strict";a["default"]=DS.Model.extend({label:DS.attr(),marketid:DS.attr(),primary_currency_code:DS.attr(),primary_currency_name:DS.attr(),secondary_currency_code:DS.attr(),secondary_currency_name:DS.attr(),market_trades:DS.hasMany("market_trade")})}),define("appkit/models/market_order",["exports"],function(a){"use strict";a["default"]=DS.Model.extend({order_type:DS.attr("string"),price:DS.attr("number"),quantity:DS.attr("number"),total:DS.attr("number"),market:DS.belongsTo("market")})}),define("appkit/models/market_trade",["exports"],function(a){"use strict";a["default"]=DS.Model.extend({marketid:DS.attr("string"),tradeid:DS.attr("string"),datetime:DS.attr("date"),tradeprice:DS.attr("number"),quantity:DS.attr("number"),total:DS.attr("number"),initiate_ordertype:DS.attr("string"),market:DS.belongsTo("market")})}),define("appkit/router",["exports"],function(a){"use strict";var b=Ember.Router.extend();b.map(function(){this.route("component-test"),this.route("helper-test"),this.resource("markets"),this.resource("market",{path:"/market/:market_id"},function(){this.route("trades"),this.route("buy"),this.route("sell")}),this.route("settings"),this.route("feedback")}),a["default"]=b}),define("appkit/routes/application",["exports"],function(a){"use strict";a["default"]=Ember.Route.extend({setupController:function(){var a=JSON.parse(window.localStorage.getItem("application.bookmarks")||null)||[];this.controller.set("bookmarks",a)},actions:{showSidebar:function(){this.controller.set("showSidebar",!0)},hideSidebar:function(){this.controller.set("showSidebar",!1)},historyBack:function(){window.history.back()},willTransition:function(){this.controller.set("showSidebar",!1)},addBookmark:function(a){var b=a.get("id"),c=a.get("label"),d=this.controller.get("bookmarks").findBy("id",b);d||(d={id:b,label:c},this.controller.get("bookmarks").pushObject(d))},removeBookmark:function(a){var b=a.get("id"),c=this.controller.get("bookmarks").findBy("id",b);c&&this.controller.get("bookmarks").removeObject(c)}}})}),define("appkit/routes/component_test",["exports"],function(a){"use strict";a["default"]=Ember.Route.extend({model:function(){return["purple","green","orange"]}})}),define("appkit/routes/feedback",["exports"],function(a){"use strict";a["default"]=Ember.Route.extend({deactivate:function(){this.controller.set("showThankYouMessage",!1)}})}),define("appkit/routes/helper_test",["exports"],function(a){"use strict";a["default"]=Ember.Route.extend({model:function(){return{name:"rebmE"}}})}),define("appkit/routes/index",["exports"],function(a){"use strict";a["default"]=Ember.Route.extend({model:function(){return null}})}),define("appkit/routes/market",["exports"],function(a){"use strict";a["default"]=Ember.Route.extend({model:function(a){console.log("Getting market with ID="+a.market_id);return this.store.find("market",a.market_id).then(function(a){return a})},setupController:function(a,b){a.set("model",b)},actions:{refresh:function(){this.controllerFor(this.controller.get("lastChildRoute")).refresh()}}})}),define("appkit/routes/market/buy",["exports"],function(a){"use strict";a["default"]=Ember.Route.extend({model:function(a,b){var c=b.resolvedModels.market;return this.store.find("market_order",{marketid:c.get("marketid"),order_type:"Sell"})},activate:function(){var a=this.controllerFor("market");a.set("lastChildRoute",this.routeName)}})}),define("appkit/routes/market/sell",["exports"],function(a){"use strict";a["default"]=Ember.Route.extend({model:function(a,b){var c=b.resolvedModels.market;return this.store.find("market_order",{marketid:c.get("marketid"),order_type:"Buy"})},activate:function(){var a=this.controllerFor("market");a.set("lastChildRoute",this.routeName)}})}),define("appkit/routes/market/trades",["exports"],function(a){"use strict";a["default"]=Ember.Route.extend({model:function(a,b){this.set("market",b.resolvedModels.market);var c=this.get("market");return this.store.find("market_trade",{marketid:c.get("marketid")})},setupController:function(a,b){a.set("model",b);this.get("market")},activate:function(){var a=this.controllerFor("market");a.set("lastChildRoute",this.routeName)}})}),define("appkit/routes/markets",["exports"],function(a){"use strict";a["default"]=Ember.Route.extend({model:function(){return this.store.find("market")}})}),define("appkit/utils/ajax",["exports"],function(a){"use strict";a["default"]=function(){return ic.ajax.apply(null,arguments)}}),define("appkit/views/graph",["appkit/controllers/graph","exports"],function(a,b){"use strict";var c=a["default"];b["default"]=Ember.View.extend({tagName:"div",classNames:["highcharts"],categories:[],data:[],graphController:null,didInsertElement:function(){var a=new c;a.initGraph(this.get("elementId"),this.get("data"),this.get("categories"),this.get("title")),this.set("graphController",a)},refresh:function(){var a=this.set("graphController",a);a.destroyGraph(),a.initGraph(this.get("elementId"),this.get("data"),this.get("categories"),this.get("title"))}.observes("data.@each","categories.@each")})}),define("appkit/templates/application",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){function f(a,b){b.buffer.push("Dashboard")}function g(a,b){b.buffer.push("Markets")}function h(a,b){var d,e,f,g="";return b.buffer.push("\n            <li>"),e=c["link-to"]||a&&a["link-to"],f={hash:{},hashTypes:{},hashContexts:{},inverse:o.noop,fn:o.program(6,i,b),contexts:[a,a],types:["STRING","ID"],data:b},d=e?e.call(a,"market.trades","id",f):p.call(a,"link-to","market.trades","id",f),(d||0===d)&&b.buffer.push(d),b.buffer.push("</li>\n          "),g}function i(a,b){var d;d=c._triageMustache.call(a,"label",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),b.buffer.push(d||0===d?d:"")}function j(a,b){b.buffer.push("Feedback")}this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var k,l,m,n="",o=this,p=c.helperMissing,q=this.escapeExpression;return e.buffer.push('<section id="index" data-position="current">\n  <section data-type="sidebar">\n    <header>\n      <menu type="toolbar">\n        <a href="#" '),e.buffer.push(q(c.action.call(b,"hideSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["STRING"],data:e}))),e.buffer.push('>Done</a>\n      </menu>\n      <a href="#" '),e.buffer.push(q(c.action.call(b,"hideSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["STRING"],data:e}))),e.buffer.push("><h1>Menu</h1></a>\n    </header>\n    <nav>\n      <ul>\n        <li>"),l=c["link-to"]||b&&b["link-to"],m={hash:{},hashTypes:{},hashContexts:{},inverse:o.noop,fn:o.program(1,f,e),contexts:[b],types:["STRING"],data:e},k=l?l.call(b,"index",m):p.call(b,"link-to","index",m),(k||0===k)&&e.buffer.push(k),e.buffer.push("</li>\n        <li>"),l=c["link-to"]||b&&b["link-to"],m={hash:{},hashTypes:{},hashContexts:{},inverse:o.noop,fn:o.program(3,g,e),contexts:[b],types:["STRING"],data:e},k=l?l.call(b,"markets",m):p.call(b,"link-to","markets",m),(k||0===k)&&e.buffer.push(k),e.buffer.push("</li>\n      </ul>\n      <h2>Bookmarks</h2>\n      <ul>\n          "),k=c.each.call(b,"bookmarks",{hash:{},hashTypes:{},hashContexts:{},inverse:o.noop,fn:o.program(5,h,e),contexts:[b],types:["ID"],data:e}),(k||0===k)&&e.buffer.push(k),e.buffer.push("\n      </ul>\n      <h2>Other</h2>\n      <ul>\n        <li>"),l=c["link-to"]||b&&b["link-to"],m={hash:{},hashTypes:{},hashContexts:{},inverse:o.noop,fn:o.program(8,j,e),contexts:[b],types:["STRING"],data:e},k=l?l.call(b,"feedback",m):p.call(b,"link-to","feedback",m),(k||0===k)&&e.buffer.push(k),e.buffer.push('</li>\n      </ul>\n    </nav>\n  </section>\n  <div id="drawer" role="region"  '),e.buffer.push(q(c["bind-attr"].call(b,{hash:{"class":"showSidebar"},hashTypes:{"class":"STRING"},hashContexts:{"class":b},contexts:[],types:[],data:e}))),e.buffer.push(">\n      "),k=c._triageMustache.call(b,"outlet",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(k||0===k)&&e.buffer.push(k),e.buffer.push("\n  </div>\n</section>"),n})}),define("appkit/templates/component-test",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){function f(a,b){var d,e,f="";return b.buffer.push("\n  "),b.buffer.push(j((d=c["pretty-color"]||a&&a["pretty-color"],e={hash:{name:""},hashTypes:{name:"ID"},hashContexts:{name:a},contexts:[],types:[],data:b},d?d.call(a,e):i.call(a,"pretty-color",e)))),b.buffer.push("\n"),f}this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var g,h="",i=c.helperMissing,j=this.escapeExpression,k=this;return g=c.each.call(b,{hash:{},hashTypes:{},hashContexts:{},inverse:k.noop,fn:k.program(1,f,e),contexts:[],types:[],data:e}),(g||0===g)&&e.buffer.push(g),e.buffer.push("\n"),h})}),define("appkit/templates/components/pretty-color",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var f,g="";return e.buffer.push("Pretty Color: "),f=c._triageMustache.call(b,"name",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(f||0===f)&&e.buffer.push(f),e.buffer.push("\n"),g})}),define("appkit/templates/error",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var f,g="";return e.buffer.push("<h1>Sorry, Something went wrong</h1>\n"),f=c._triageMustache.call(b,"message",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(f||0===f)&&e.buffer.push(f),e.buffer.push("\n<pre>\n"),f=c._triageMustache.call(b,"stack",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(f||0===f)&&e.buffer.push(f),e.buffer.push("\n</pre>\n"),g})}),define("appkit/templates/feedback",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){function f(a,b){var d="";return b.buffer.push('\n        <a href="#" '),b.buffer.push(m(c.action.call(a,"hideSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push('><span class="icon icon-menu">hide sidebar</span></a>\n      '),d}function g(a,b){var d="";return b.buffer.push('\n        <a href="#" '),b.buffer.push(m(c.action.call(a,"showSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push('><span class="icon icon-menu">show sidebar</span></a>\n      '),d}function h(a,b){var d,e,f="";return b.buffer.push("\n        <header>Let us know</header>\n        <p>\n            "),b.buffer.push(m((d=c.textarea||a&&a.textarea,e={hash:{value:"input"},hashTypes:{value:"ID"},hashContexts:{value:a},contexts:[],types:[],data:b},d?d.call(a,e):n.call(a,"textarea",e)))),b.buffer.push('\n        </p>\n        <a class="recommend" role="button" '),b.buffer.push(m(c.action.call(a,"submit",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push(">Send</a>\n      "),f}function i(a,b){var d,e,f,g="";return b.buffer.push('\n        <p class="text-center">\n\n        <h1 class="text-center">Thank you</h1></p>\n        <p class="text-center">\n            '),e=c["link-to"]||a&&a["link-to"],f={hash:{},hashTypes:{},hashContexts:{},inverse:o.noop,fn:o.program(8,j,b),contexts:[a],types:["STRING"],data:b},d=e?e.call(a,"index",f):n.call(a,"link-to","index",f),(d||0===d)&&b.buffer.push(d),b.buffer.push("\n        </p>\n      "),g}function j(a,b){b.buffer.push("Go to dashboard")}this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var k,l="",m=this.escapeExpression,n=c.helperMissing,o=this;return e.buffer.push('<section id="drawer" role="region">\n  <header class="fixed">\n      '),k=c["if"].call(b,"showSidebar",{hash:{},hashTypes:{},hashContexts:{},inverse:o.program(3,g,e),fn:o.program(1,f,e),contexts:[b],types:["ID"],data:e}),(k||0===k)&&e.buffer.push(k),e.buffer.push("\n    <h1>"),k=c._triageMustache.call(b,"GLOBAL_APPNAME",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(k||0===k)&&e.buffer.push(k),e.buffer.push(' <em>user feedback</em></h1>\n  </header>\n  <article class="content scrollable header" data-type="list">\n    <!--<header>Vote for features</header>-->\n    <!--<li>-->\n    <!--<p>Travis Gray</p>-->\n    <!--<p>Beginning of message</p>-->\n    <!--</li>-->\n    <!--</ul>-->\n      '),k=c.unless.call(b,"showThankYouMessage",{hash:{},hashTypes:{},hashContexts:{},inverse:o.program(7,i,e),fn:o.program(5,h,e),contexts:[b],types:["ID"],data:e}),(k||0===k)&&e.buffer.push(k),e.buffer.push("\n  </article>\n</section>\n\n\n\n\n"),l})}),define("appkit/templates/helper-test",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var f,g,h="",i=c.helperMissing,j=this.escapeExpression;return e.buffer.push("<h3>My name is "),e.buffer.push(j((f=c["reverse-word"]||b&&b["reverse-word"],g={hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e},f?f.call(b,"name",g):i.call(b,"reverse-word","name",g)))),e.buffer.push(".</h3>\n"),h})}),define("appkit/templates/index",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){function f(a,b){var d="";return b.buffer.push('\n        <a href="#" '),b.buffer.push(m(c.action.call(a,"hideSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push('><span class="icon icon-menu">hide sidebar</span></a>\n      '),d}function g(a,b){var d="";return b.buffer.push('\n        <a href="#" '),b.buffer.push(m(c.action.call(a,"showSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push('><span class="icon icon-menu">show sidebar</span></a>\n      '),d}function h(a,b){b.buffer.push("markets list")}this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var i,j,k,l="",m=this.escapeExpression,n=this,o=c.helperMissing;return e.buffer.push('<section id="drawer" role="region">\n  <header class="fixed">\n      '),i=c["if"].call(b,"showSidebar",{hash:{},hashTypes:{},hashContexts:{},inverse:n.program(3,g,e),fn:n.program(1,f,e),contexts:[b],types:["ID"],data:e}),(i||0===i)&&e.buffer.push(i),e.buffer.push("\n    <h1>"),i=c._triageMustache.call(b,"GLOBAL_APPNAME",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(i||0===i)&&e.buffer.push(i),e.buffer.push(' <em>dashboard</em></h1>\n  </header>\n  <article class="content scrollable header">\n    <p>\n\n    <h2>Welcome to <a href="http://www.cryptsy.com" target="_blank">Cryptsy</a> FirefoxOS client</h2>\n\n    <!--<h3>If you need informations about digital coins everywhere you go</h3>-->\n    </p>\n    <p>Official <a href="http://www.cryptsy.com" target="_blank">Cryptsy website</a></p>\n    <!--<p>From here you can go to '),j=c["link-to"]||b&&b["link-to"],k={hash:{},hashTypes:{},hashContexts:{},inverse:n.noop,fn:n.program(5,h,e),contexts:[b],types:["STRING"],data:e},i=j?j.call(b,"markets",k):o.call(b,"link-to","markets",k),(i||0===i)&&e.buffer.push(i),e.buffer.push('</p>-->\n    </p>\n    <p>\n      <a class="twitter-timeline" href="https://twitter.com/cryptsy" data-widget-id="436662507197849600" target="_blank">Tweets by\n        @cryptsy</a>\n    </p>\n\n  </article>\n</section>\n\n\n\n\n'),l})}),define("appkit/templates/loading",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{},e.buffer.push('<section id="drawer" role="region">\n  <h1 class="loading">Loading...</h1>\n</section>')})}),define("appkit/templates/market",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){function f(a,b){var d="";return b.buffer.push('\n        <a href="#" '),b.buffer.push(q(c.action.call(a,"hideSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push('><span class="icon icon-menu">hide sidebar</span></a>\n      '),d}function g(a,b){var d="";return b.buffer.push('\n        <a href="#" '),b.buffer.push(q(c.action.call(a,"showSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push('><span class="icon icon-menu">show sidebar</span></a>\n      '),d}function h(a,b){var d="";return b.buffer.push('\n          <a href="#" '),b.buffer.push(q(c.action.call(a,"addBookmark","",{hash:{},hashTypes:{},hashContexts:{},contexts:[a,a],types:["STRING","ID"],data:b}))),b.buffer.push('><span class="icon action-icon-hack"><span\n                  class="action-icon bookmark"></span></span></a>\n        '),d}function i(a,b){var d="";return b.buffer.push('\n          <a href="#" '),b.buffer.push(q(c.action.call(a,"removeBookmark","",{hash:{},hashTypes:{},hashContexts:{},contexts:[a,a],types:["STRING","ID"],data:b}))),b.buffer.push('><span class="icon action-icon-hack"><span\n                  class="action-icon bookmarked"></span></span></a>\n        '),d}function j(a,b){b.buffer.push("Trades")}function k(a,b){b.buffer.push("Sell orders")}function l(a,b){b.buffer.push("Buy orders")}this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var m,n,o,p="",q=this.escapeExpression,r=this,s=c.helperMissing;return e.buffer.push('<section id="drawer" role="region">\n  <header class="fixed">\n      '),m=c["if"].call(b,"showSidebar",{hash:{},hashTypes:{},hashContexts:{},inverse:r.program(3,g,e),fn:r.program(1,f,e),contexts:[b],types:["ID"],data:e}),(m||0===m)&&e.buffer.push(m),e.buffer.push('\n    <menu type="toolbar">\n      <a href="#" '),e.buffer.push(q(c.action.call(b,"refresh",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["STRING"],data:e}))),e.buffer.push('><span class="icon action-icon-hack"><span\n              class="action-icon email-sync"></span></span></a>\n        '),m=c.unless.call(b,"isBookmarked",{hash:{},hashTypes:{},hashContexts:{},inverse:r.program(7,i,e),fn:r.program(5,h,e),contexts:[b],types:["ID"],data:e}),(m||0===m)&&e.buffer.push(m),e.buffer.push("\n    </menu>\n    <h1>"),m=c._triageMustache.call(b,"GLOBAL_APPNAME",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(m||0===m)&&e.buffer.push(m),e.buffer.push(" <em>"),m=c._triageMustache.call(b,"label",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(m||0===m)&&e.buffer.push(m),e.buffer.push(' market</em></h1>\n  </header>\n  <article class="content scrollable header footer">\n    '),m=c._triageMustache.call(b,"outlet",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(m||0===m)&&e.buffer.push(m),e.buffer.push('\n    <p class="text-center"><a '),e.buffer.push(q(c["bind-attr"].call(b,{hash:{href:"cryptsyLink"},hashTypes:{href:"ID"},hashContexts:{href:b},contexts:[],types:[],data:e}))),e.buffer.push(' target="_blank">Cryptsy market link</a></p>\n  </article>\n  <ul role="tablist">\n    <li role="tab">\n      '),n=c["link-to"]||b&&b["link-to"],o={hash:{},hashTypes:{},hashContexts:{},inverse:r.noop,fn:r.program(9,j,e),contexts:[b,b],types:["STRING","ID"],data:e},m=n?n.call(b,"market.trades","",o):s.call(b,"link-to","market.trades","",o),(m||0===m)&&e.buffer.push(m),e.buffer.push('\n    </li>\n    <li role="tab">\n        '),n=c["link-to"]||b&&b["link-to"],o={hash:{},hashTypes:{},hashContexts:{},inverse:r.noop,fn:r.program(11,k,e),contexts:[b,b],types:["STRING","ID"],data:e},m=n?n.call(b,"market.buy","",o):s.call(b,"link-to","market.buy","",o),(m||0===m)&&e.buffer.push(m),e.buffer.push('\n    </li>\n    <li role="tab">\n        '),n=c["link-to"]||b&&b["link-to"],o={hash:{},hashTypes:{},hashContexts:{},inverse:r.noop,fn:r.program(13,l,e),contexts:[b,b],types:["STRING","ID"],data:e},m=n?n.call(b,"market.sell","",o):s.call(b,"link-to","market.sell","",o),(m||0===m)&&e.buffer.push(m),e.buffer.push("\n    </li>\n  </ul>\n</section>\n\n"),p})}),define("appkit/templates/market/buy",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){function f(a,b){var d,e,f,g="";return b.buffer.push("\n        <li><a>\n          <p>\n            <span >"),d=c._triageMustache.call(a,"order_type",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push(" - "),b.buffer.push(j((e=c["format-price"]||a&&a["format-price"],f={hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b},e?e.call(a,"price",f):i.call(a,"format-price","price",f)))),b.buffer.push("</span>\n          </p>\n\n          <p>QTY: "),d=c._triageMustache.call(a,"quantity",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push(" - TOTAL(BTC): "),d=c._triageMustache.call(a,"total",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push("</p>\n        </a></li>\n      "),g}this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var g,h="",i=c.helperMissing,j=this.escapeExpression,k=this;return e.buffer.push('<div data-type="list">\n  <ul>\n      '),g=c.each.call(b,{hash:{},hashTypes:{},hashContexts:{},inverse:k.noop,fn:k.program(1,f,e),contexts:[],types:[],data:e}),(g||0===g)&&e.buffer.push(g),e.buffer.push("\n  </ul>\n</div>"),h})}),define("appkit/templates/market/sell",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){function f(a,b){var d,e,f,g="";return b.buffer.push("\n        <li><a>\n          <p>\n                <span >"),d=c._triageMustache.call(a,"order_type",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push(" - "),b.buffer.push(j((e=c["format-price"]||a&&a["format-price"],f={hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b},e?e.call(a,"price",f):i.call(a,"format-price","price",f)))),b.buffer.push("</span>\n          </p>\n\n          <p>QTY: "),d=c._triageMustache.call(a,"quantity",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push(" - TOTAL(BTC): "),d=c._triageMustache.call(a,"total",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push("</p>\n        </a></li>\n      "),g}this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var g,h="",i=c.helperMissing,j=this.escapeExpression,k=this;return e.buffer.push('<div data-type="list">\n  <ul>\n      '),g=c.each.call(b,{hash:{},hashTypes:{},hashContexts:{},inverse:k.noop,fn:k.program(1,f,e),contexts:[],types:[],data:e}),(g||0===g)&&e.buffer.push(g),e.buffer.push("\n  </ul>\n</div>"),h})}),define("appkit/templates/market/trades",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){function f(a,b){var d,e,f,g="";return b.buffer.push("\n        <li><a>\n          <p>\n                <span "),b.buffer.push(i(c["bind-attr"].call(a,{hash:{"class":"this.initiate_ordertype"},hashTypes:{"class":"STRING"},hashContexts:{"class":a},contexts:[],types:[],data:b}))),b.buffer.push(">"),d=c._triageMustache.call(a,"initiate_ordertype",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push("\n                  - "),b.buffer.push(i((e=c["format-price"]||a&&a["format-price"],f={hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b},e?e.call(a,"tradeprice",f):j.call(a,"format-price","tradeprice",f)))),b.buffer.push("</span>\n          </p>\n\n          <p>"),b.buffer.push(i((e=c["format-datetime"]||a&&a["format-datetime"],f={hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b},e?e.call(a,"datetime",f):j.call(a,"format-datetime","datetime",f)))),b.buffer.push(" - QTY: "),d=c._triageMustache.call(a,"quantity",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push("</p>\n        </a></li>\n      "),g}this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var g,h="",i=this.escapeExpression,j=c.helperMissing,k=this;return e.buffer.push('<div data-type="list">\n  <ul>\n      '),g=c.each.call(b,{hash:{},hashTypes:{},hashContexts:{},inverse:k.noop,fn:k.program(1,f,e),contexts:[],types:[],data:e}),(g||0===g)&&e.buffer.push(g),e.buffer.push("\n  </ul>\n</div>"),h})}),define("appkit/templates/markets",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){function f(a,b){var d="";return b.buffer.push('\n        <a href="#" '),b.buffer.push(l(c.action.call(a,"hideSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push('><span class="icon icon-menu">hide sidebar</span></a>\n      '),d
}function g(a,b){var d="";return b.buffer.push('\n        <a href="#" '),b.buffer.push(l(c.action.call(a,"showSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push('><span class="icon icon-menu">show sidebar</span></a>\n      '),d}function h(a,b){var d,e,f,g="";return b.buffer.push("\n            <li "),b.buffer.push(l(c["bind-attr"].call(a,{hash:{"class":"market.secondary_currency_code"},hashTypes:{"class":"STRING"},hashContexts:{"class":a},contexts:[],types:[],data:b}))),b.buffer.push(">\n              "),d=c._triageMustache.call(a,"getColor",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push("\n                "),e=c["link-to"]||a&&a["link-to"],f={hash:{},hashTypes:{},hashContexts:{},inverse:m.noop,fn:m.program(6,i,b),contexts:[a,a],types:["STRING","ID"],data:b},d=e?e.call(a,"market.trades","market",f):n.call(a,"link-to","market.trades","market",f),(d||0===d)&&b.buffer.push(d),b.buffer.push("\n            </li>\n          "),g}function i(a,b){var d,e="";return b.buffer.push("\n                  <p>"),d=c._triageMustache.call(a,"market.label",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push(" &nbsp;<em>"),d=c._triageMustache.call(a,"market.primary_currency_name",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push("\n                    / "),d=c._triageMustache.call(a,"market.secondary_currency_name",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["ID"],data:b}),(d||0===d)&&b.buffer.push(d),b.buffer.push("</em></p>\n                "),e}this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var j,k="",l=this.escapeExpression,m=this,n=c.helperMissing;return e.buffer.push('<section id="drawer" role="region">\n  <header class="fixed">\n      '),j=c["if"].call(b,"showSidebar",{hash:{},hashTypes:{},hashContexts:{},inverse:m.program(3,g,e),fn:m.program(1,f,e),contexts:[b],types:["ID"],data:e}),(j||0===j)&&e.buffer.push(j),e.buffer.push("\n\n    <h1>"),j=c._triageMustache.call(b,"GLOBAL_APPNAME",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(j||0===j)&&e.buffer.push(j),e.buffer.push(' <em>markets</em></h1>\n  </header>\n  <article class="content scrollable header">\n    <div data-type="list">\n      <ul>\n          '),j=c.each.call(b,"market","in","",{hash:{},hashTypes:{},hashContexts:{},inverse:m.noop,fn:m.program(5,h,e),contexts:[b,b,b],types:["ID","ID","ID"],data:e}),(j||0===j)&&e.buffer.push(j),e.buffer.push("\n      </ul>\n    </div>\n  </article>\n</section>\n"),k})}),define("appkit/templates/settings",["exports"],function(a){a["default"]=Ember.Handlebars.template(function(a,b,c,d,e){function f(a,b){var d="";return b.buffer.push('\n        <a href="#" '),b.buffer.push(j(c.action.call(a,"hideSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push('><span class="icon icon-menu">hide sidebar</span></a>\n      '),d}function g(a,b){var d="";return b.buffer.push('\n        <a href="#" '),b.buffer.push(j(c.action.call(a,"showSidebar",{hash:{},hashTypes:{},hashContexts:{},contexts:[a],types:["STRING"],data:b}))),b.buffer.push('><span class="icon icon-menu">show sidebar</span></a>\n      '),d}this.compilerInfo=[4,">= 1.0.0"],c=this.merge(c,Ember.Handlebars.helpers),e=e||{};var h,i="",j=this.escapeExpression,k=this;return e.buffer.push('<section id="drawer" role="region">\n  <header class="fixed">\n      '),h=c["if"].call(b,"showSidebar",{hash:{},hashTypes:{},hashContexts:{},inverse:k.program(3,g,e),fn:k.program(1,f,e),contexts:[b],types:["ID"],data:e}),(h||0===h)&&e.buffer.push(h),e.buffer.push("\n    <h1>"),h=c._triageMustache.call(b,"GLOBAL_APPNAME",{hash:{},hashTypes:{},hashContexts:{},contexts:[b],types:["ID"],data:e}),(h||0===h)&&e.buffer.push(h),e.buffer.push(' <em>settings</em></h1>\n  </header>\n  <article class="content scrollable header" data-type="list">\n    <header>Cryptsy account</header>\n    <ul>\n      <li>\n        <p>API key</p>\n      </li>\n      <li>\n        <p>API secret</p>\n      </li>\n      <li>\n          <p>Travis Gray</p>\n\n          <p>Beginning of message</p>\n      </li>\n    </ul>\n    <header>Markets</header>\n    <ul>\n      <li>\n        <p>Travis Gray</p>\n        <p>Disabled item</p>\n      </li>\n    </ul>\n\n  </article>\n</section>\n\n\n\n\n'),i})});