appUrl = 'http://www.crazeapp.us/app/';
profileImageUrl = 'http://www.crazeapp.us/uploads/profile/';
postImageUrl = 'http://www.crazeapp.us/uploads/post/';

// individual post
function individualPost(post, showComments) {
	// find and replace hashtags
	hashRegEx = new RegExp(/(#\w+)/g);
	post.content_text = post.content_text.replace(hashRegEx, '<a href="#" class="hashtag_link">$&</a>');
	mentionRegEx = new RegExp(/(@\w+)/g);
	post.content_text = post.content_text.replace(mentionRegEx, '<a href="#" class="mention_link">$&</a>');
	individualPostHtml = '<div class="post">' +
							'<a class="user" id="user' + post.user + '" data-transition="none">' +
								'<span>' + post.username + '</span>' +
						 		'<img src="' + profileImageUrl + post.user_image + '">' +
							'</a>' +
							(post.content_image ? '<a href="#individual_post" id="content_image_link' + post.id + '"><img class="content_image" src="' + postImageUrl + post.content_image + '"></a>' : '') +
							(post.content_text ? '<div class="content_text">' + post.content_text + '</div>' : '') +
						 	'<div data-role="controlgroup" data-type="horizontal" data-mini="true" class="post_metrics">' +
						 		'<a data-role="button" data-icon="arrow-u" data-iconpos="left" class="vote_up" id="vote_up' + post.id + '">' + post.up_votes + '</a>' +
						 		'<a data-role="button" data-icon="heart" data-iconpos="left" class="favorite" id="favorite' + post.id + '">' + post.favorites + '</a>' +
						 		'<a data-role="button" data-icon="arrow-d" data-iconpos="left" class="vote_down" id="vote_down' + post.id + '">' + post.down_votes + '</a>' +
						 	'</div>' +
						 	(showComments ? '<textarea class="comment_input" id="comment_input' + post.id + '" placeholder="Comment..."></textarea><span data-role="button" class="comment_submit" id="comment_submit' + post.id + '" data-icon="plus" data-mini="true">Add Comment</span><div class="comments"></div>' : '<a data-role="button" data-icon="comment" data-mini="true" class="view_comments" id="view_comments' + post.id + '">view/add comments</a>') +
						 '</div>';
	return individualPostHtml;
	
}

// individual comment
function individualComment(comment) {
	individualCommentHtml = '<div class="comment">' +
								'<a class="user" id="user' + comment.user +'">' +
									'<span>' + comment.username + '</span>' +
						 			'<img src="' + profileImageUrl + comment.image + '">' +
								'</a>' +
								'<span class="comment_date">' + comment.date + '</span>' +
								'<span class="comment_text">' + comment.content_text + '</span>' +
							'</div>';
	return individualCommentHtml;
}

// profile side
function profileSide(userData) {
	profileSideHtml = '<img class="profile_image" id="profile_img' + userData.id + '" src="' + profileImageUrl + userData.image + '">' +
					  '<span class="profile_username">' + userData.username + '</span>' +
					  '<a data-role="button" data-icon="star" data-mini="true" class="become_fan" id="become_fan' + userData.id + '">Fan</a>' +
					  '<a data-role="button" data-icon="heart" data-mini="true" class="become_vip" id="become_vip' + userData.id + '">VIP</a>';
	return profileSideHtml;
}

// user list item
function userListItem(item) {
	userListItemHtml = '<li>' +
					       '<a class="user_link" id="user_link' + item.id + '">' +
					           '<img src="' + profileImageUrl + item.image + '">' +
					           item.username +
					       '</a>' +
					   '</li>';
	return userListItemHtml;
}

// notifications list
function notificationsListItem(notification) {
	if (notification.type == 1) {
		// vip request
		return '<div class="notification">' + 
					'<img src="' + profileImageUrl + notification.from_user_image + '">' + 
					'<p>' + 
						notification.from_username + ' sent you a VIP request' +
					'</p>' +
					'<a data-role="button" class="accept_vip notification_button" id="accept_vip' + notification.id + '">Accept</a>' +
					'<a data-role="button" class="deny_vip notification_button" id="deny_vip' + notification.id + '">Deny</a>' +
			   '</div>';
	}
	if (notification.type == 2) {
		// got a fan
		return '<div class="notification">' + 
					'<img src="' + profileImageUrl + notification.from_user_image + '">' + 
					'<p>' + 
						notification.from_username + ' became your fan' +
					'</p>' +
					'<a data-role="button" class="delete_notification notification_button" id="delete_notification' + notification.id + '">Delete Notification</a>' +
				'</div>';
	}
	if (notification.type == 3) {
		// vip request was accepted
		return '<div class="notification">' + 
					'<img src="' + profileImageUrl + notification.from_user_image + '">' + 
					'<p>' + 
						notification.from_username + ' accepted your VIP request' +
					'</p>' +
					'<a data-role="button" class="delete_notification notification_button" id="delete_notification' + notification.id + '">Delete Notification</a>' +
				'</div>';
	}
	if (notification.type == 4) {
		// vip request was denied
		return '<div class="notification">' + 
					'<img src="' + profileImageUrl + notification.from_user_image + '">' + 
					'<p>' + 
						notification.from_username + ' denied your VIP request' +
					'</p>' +
					'<a data-role="button" class="delete_notification notification_button" id="delete_notification' + notification.id + '">Delete Notification</a>' +
				'</div>';
	}
	if (notification.type == 5) {
		// user's post was featured
		return '<div class="notification">' + 
					'<img src="' + profileImageUrl + notification.from_user_image + '">' + 
					'<p>' + 
						notification.from_username + ' featured your post' +
					'</p>' +
					'<a data-role="button" class="view_post notification_button" id="view_post' + notification.content + '">View Post</a>' +
					'<a data-role="button" class="delete_notification notification_button" id="delete_notification' + notification.id + '">Delete Notification</a>' +
				'</div>';
	}
	if (notification.type == 6) {
		// got a comment on a post
		return '<div class="notification">' + 
					'<img src="' + profileImageUrl + notification.from_user_image + '">' + 
					'<p>' + 
						notification.from_username + ' commented on your post' +
					'</p>' +
					'<a data-role="button" class="view_post notification_button" id="view_post' + notification.content + '">View Post</a>' +
					'<a data-role="button" class="delete_notification notification_button" id="delete_notification' + notification.id + '">Delete Notification</a>' +
				'</div>';
	}
	if (notification.type == 7) {
		// fan request for private user
		return '<div class="notification">' + 
					'<img src="' + profileImageUrl + notification.from_user_image + '">' + 
					'<p>' + 
						notification.from_username + ' sent you a fan request' +
					'</p>' +
					'<a data-role="button" class="accept_fan notification_button" id="accept_fan' + notification.id + '">Accept</a>' +
					'<a data-role="button" class="deny_fan notification_button" id="deny_fan' + notification.id + '">Deny</a>' +
			   '</div>';
	}
	if (notification.type == 8) {
		// fan request was accepted
		return '<div class="notification">' + 
					'<img src="' + profileImageUrl + notification.from_user_image + '">' + 
					'<p>' + 
						notification.from_username + ' accepted your fan request' +
					'</p>' +
					'<a data-role="button" class="delete_notification notification_button" id="delete_notification' + notification.id + '">Delete Notification</a>' +
				'</div>';
	}
	if (notification.type == 9) {
		// fan request was denied
		return '<div class="notification">' + 
					'<img src="' + profileImageUrl + notification.from_user_image + '">' + 
					'<p>' + 
						notification.from_username + ' denied your fan request' +
					'</p>' +
					'<a data-role="button" class="delete_notification notification_button" id="delete_notification' + notification.id + '">Delete Notification</a>' +
				'</div>';
	}
	if (notification.type == 10) {
		// received an @mention
		return '<div class="notification">' + 
					'<img src="' + profileImageUrl + notification.from_user_image + '">' + 
					'<p>' + 
						notification.from_username + ' mentioned you in a post' +
					'</p>' +
					'<a data-role="button" class="view_post notification_button" id="view_post' + notification.content + '">View Post</a>' +
					'<a data-role="button" class="delete_notification notification_button" id="delete_notification' + notification.id + '">Delete Notification</a>' +
				'</div>';
	}
}