	var canvas;
	var ctx;
	var lastPt=null;
	var mapPt=null;
	var startPt=null;
	var startPinch=null;
	var endPinch=null;
	
	var tiles1200 = new Array(18);
	var tiles2400 = new Array(72);
	var tiles4800 = new Array(288);
	var tiles9600 = new Array(1152);
	var swidth;
	var sheight;
	var touchzone;
	var imagesloaded=false;
	
	var zoom=1.0;
	var minzoom=0.25;
	var basemap = {x:2400,y:1200,tile:200};
	var mapsize = {x:2400,y:1200,tile:200};
 
	function init() {
		touchzone = document.getElementById("myCanvas");

		swidth = window.innerWidth;
		sheight = window.innerHeight;
		//console.log("width:" + swidth + "  height:" + sheight);
		if (swidth > 1280) {
			swidth  = 1280;			
			touchzone.style.border = "1px solid #000";
		}
		if (sheight > 1280) {
			sheight = 1280;
			touchzone.style.border = "1px solid #000";
		}

		touchzone.width = swidth;
		touchzone.height = sheight;
	
		loadImages();
	        touchzone.addEventListener("touchmove", movePoint, false);
		touchzone.addEventListener("touchstart", startPoint, false);
	        touchzone.addEventListener("touchend", endPoint, false);
		ScreenOrientationManager.init();
		ScreenOrientationManager.handleOrientationChange({
			portraitPrimaryCallback: orientUpdate,
			landscapePrimaryCallback: orientUpdate,
			portraitSecondaryCallback: orientUpdate,
			landscapeSecondaryCallback: orientUpdate
		});
		setMinZoom();
		ctx = touchzone.getContext("2d");
	}

	function movePoint(e) {
		e.preventDefault();
    
		if (e.touches.length==2)
		{		
			if (startPinch==null)
			{
				startPinch={x1:e.touches[0].pageX, y1:e.touches[0].pageY, x2:e.touches[1].pageX, y2:e.touches[1].pageY};
			}
			else
			{
				endPinch = {x1:e.touches[0].pageX, y1:e.touches[0].pageY, x2:e.touches[1].pageX, y2:e.touches[1].pageY};
				zoomPinch();
				startPinch=endPinch;
				startPt=null;
			}
		}

		if ((e.touches.length==1) && (startPt!=null))
		{
			var touches = e.changedTouches[0];
			moveMap(touches);
			startPt = {x:e.touches[0].pageX, y:e.touches[0].pageY};
		}
       
	}

	function endPoint(e) {
		e.preventDefault();
		var touches = e.changedTouches[0];
	
		if (startPt!=null)
		{
			moveMap(touches);
		}

	        lastPt=null;
		startPt=null;
		startPinch=null;
		endPinch=null;
	}

	function moveMap(touches)
	{
		mapPt.x = mapPt.x-(touches.pageX-startPt.x);
		mapPt.y = mapPt.y-(touches.pageY-startPt.y);		
		redraw();		
	}


	function zoomPinch()
	{
		if ((startPinch!=null) && (endPinch!=null))
		{
			var dist1 = Math.sqrt(Math.pow(Math.abs(startPinch.x1-startPinch.x2),2) + Math.pow(Math.abs(startPinch.y1-startPinch.y2),2));
			var dist2 = Math.sqrt(Math.pow(Math.abs(endPinch.x1-endPinch.x2),2) + Math.pow(Math.abs(endPinch.y1-endPinch.y2),2));
				
			var diff = dist2/dist1;
			var nzoom=zoom*diff;

			if (nzoom < minzoom) nzoom=minzoom;
			if (nzoom > 8.0) nzoom=8.0;
			var xapos = (endPinch.x1+endPinch.x2)/2;
			var yapos = (endPinch.y1+endPinch.y2)/2;

			var ndiff = nzoom/zoom;
			zoom=nzoom;

			mapPt.x= ((mapPt.x+xapos)*ndiff)-xapos;
			mapPt.y= ((mapPt.y+yapos)*ndiff)-yapos;
	
			reScale();	
			redraw();
		}
	}

	function startPoint(e) {
		e.preventDefault();
		startPt = {x:e.touches[0].pageX, y:e.touches[0].pageY};	
	}

	function redraw(){
		if (!imagesloaded) return;
		
		edgeCheck();

		if (mapsize.x <= 1200)
		{
			drawMap(tiles1200,3, 6);
		}
		else if (mapsize.x <= 2400)
		{
			drawMap(tiles2400,6, 12);
		}
		else if (mapsize.x <= 4800)
		{
			drawMap(tiles4800,12,24);
		}
		else
		{
			drawMap(tiles9600,24,48);
		}
	}

	function drawMap(imgtile,rows, cols)
	{
		var xminnum = Number.toInteger(mapPt.x/mapsize.tile)
		var xmaxnum = Number.toInteger((mapPt.x+swidth)/mapsize.tile)+1;
		var yminnum = Number.toInteger(mapPt.y/mapsize.tile)
		var ymaxnum = Number.toInteger((mapPt.y+sheight)/mapsize.tile)+1;
		var imgcount=0;
		for (var x=xminnum; x<xmaxnum; x++)
			for (var y=yminnum; y<ymaxnum; y++)
			{
				var imgnum = x*rows+y;
				var xpos = (x*mapsize.tile)-mapPt.x;
				if (xpos >= swidth) continue;
				if (xpos >= mapsize.x) continue;
				var ypos = (y*mapsize.tile)-mapPt.y;
				if (ypos >= sheight) continue;
				if (ypos >= mapsize.y) continue;		
				ctx.drawImage(imgtile[imgnum],xpos,ypos,mapsize.tile,mapsize.tile);
				imgcount++;
					
			}		
	}


	function loadImages()
	{	
		initImages(tiles1200);	
		initImages(tiles2400);
		initImages(tiles4800);
		initImages(tiles9600);

		tiles9600[tiles9600.length-1].onload = function()
		{
			document.getElementById('SplashScreen').style.display = "none";
			document.getElementById('myCanvas').style.display = "block";
			mapPt = {x:((mapsize.x-swidth)/2), y:((mapsize.y-sheight)/2)};
			imagesloaded=true;
			redraw();
		}

		imgFromSrc(tiles1200,"1200");
		imgFromSrc(tiles2400,"2400");
		imgFromSrc(tiles4800,"4800");
		imgFromSrc(tiles9600,"9600");
	}

	function initImages(imgtilearr)
	{
		for (var i=0; i < imgtilearr.length; i++)
		{	
			imgtilearr[i] = new Image;
		}
	}


	function imgFromSrc(imgtilearr,folder)
	{
		for (var i=0; i < imgtilearr.length; i++)
		{
			var z1='';
			var z2='';
			var z3='';
			if (i<10)z1='0';
			if (i<100)z2='0';
			if (i<1000)z3='0';			
			imgtilearr[i].src='tiles/'+folder+'/wrld'+z1+z2+z3+i+".png";
		}
	}	

	function orientUpdate()
	{
		swidth = window.innerWidth;
		sheight = window.innerHeight;
		touchzone.width = swidth;
		touchzone.height = sheight;
		setMinZoom();	
		redraw();
	}

	function edgeCheck()
	{
		if (mapPt.x < 0) 
			mapPt.x=0;
		else if (mapPt.x > (mapsize.x-swidth)) 
			mapPt.x=(mapsize.x-swidth);

		if (mapPt.y < 0)
			mapPt.y=0;
		else if (mapPt.y > (mapsize.y-sheight)) 
			mapPt.y=(mapsize.y-sheight);
		
	}

	function setMinZoom()
	{		
		var xaxis = swidth/2400;
		var yaxis = sheight/1200;
		if (xaxis > yaxis)
		{
			minzoom = xaxis;
		}
		else
		{
			minzoom = yaxis;
		}
		if (minzoom > zoom) 
		{
			zoom=minzoom;
			reScale();
		}
	}

	function reScale()
	{
		mapsize.x = basemap.x*zoom;
		mapsize.y = basemap.y*zoom;
		mapsize.tile = basemap.tile*zoom;
		
		if (zoom <= 0.5)
			mapsize.tile = basemap.tile*zoom*2;
		else if (zoom <= 1.0)
			mapsize.tile = basemap.tile*zoom;
		else if (zoom <= 2.0)
			mapsize.tile = basemap.tile*zoom/2;
		else 
			mapsize.tile = basemap.tile*zoom/4;
	
		if (mapsize.x > 19200) mapsize.x = 19200;
		if (mapsize.y > 9600) mapsize.y = 9600;
		if (mapsize.x < 600) mapsize.x = 600;
		if (mapsize.y < 300) mapsize.y = 300;
	}


	window.onload = function() {
  		init();
	};
