/*(function() {

var n, lastPoints;
n = 90;
lastPoints = [];
for (var i=0;i<n;i++) {
	lastPoints[i] = [0.5,0.5];
}

return function() {
    var p = [];

    var r = 0.45 + 0.005 * soundData.bass;
    var stretchFactor = 0.95;

    var lastWave = 0;
    for (var i=0;i<n;i++) {
      var wave = soundData.waveDataL[(i/n*256)>>0] * 2;
      wave = (wave * 0.1 + lastWave * 0.9);
      lastWave = wave;

      var d = i/(n-1) * PI + PI;
      var d2 = d + PI2 * 1/n;
      var r2 = r + wave * 0.05;

      var x = .5 + cos(d) * r2;
      var y = .5 + sin(d) * r2;

      p[i] = [x,y+0.15];
      var lp = lastPoints[i];
      lp = [
        (lp[0] - 0.5) * stretchFactor + 0.5,
        (lp[1] - 0.5) * stretchFactor + 0.5,
      ];

      drawPath([p[i], lp], false, null, "hsl(200,80%,60%)", 1.5 + 0.4 * soundData.mid);

      lastPoints[i] = p[i];
    }

    drawPath(p, soundData.bass > 1.2, "rgba(0,0,0,0.1)", "white", 0.5);

    drawRect(0,0.655,1,0.25, "black"); // clear the spectrum bars before stretching

    stretch(stretchFactor, stretchFactor, 0.5, 0.5);

    var m = 32;
    var seg = 0.85 / m;
    var h, spec;
    for (var i=0;i<m;i++) {
      spec = pow(soundData.eqDataL[(i/m*256)>>0], 0.4);
      h = spec * 0.1;
      drawRect(0.08 + seg * i, 0.655, seg * 0.5, h, "rgba(150,200,250,1.0)");
    }

    commit();

};

})();


*/


//Create Equalizer


//music,movies,radio
currentPlayType ="music";



  var counterSong =0;
  var togglePlay=false;
  var totalSongs=new Array();
  var totalSongsCounter=0;
  var totalSongsFileName= new Array();
  var currentSongPlayingById=0;
  var isAudioPlaying=false;
  var currentSongNumber = 0;
var typeSelectorClicked = false;



function changeOrientaton(typeMedia)
{
 if(typeMedia=="music")
 { 

  var lockOrientation = screen.lockOrientation || screen.mozLockOrientation || screen.msLockOrientation;

  if(lockOrientation("portrait-primary"))
  {
   console.log("Orientation Locked");
  } 
  else
  {
   console.log("Orientation Not Locked");
    // orientation lock failed
  }

  }
  if(typeMedia=="movies")
  {
   var lockOrientation = screen.lockOrientation || screen.mozLockOrientation || screen.msLockOrientation;

  if(lockOrientation("landscape-primary"))
  {
   console.log("Orientation Locked");
  } 
  else
  {
   console.log("Orientation Not Locked");
    // orientation lock failed
  }

  }  

}







window.onload = function()
{
 
  //init slider 
  
  document.getElementById("typeSelector").addEventListener("click",function()
  { 

    if(typeSelectorClicked==true)
    {
       slider.slideIn();
       typeSelectorClicked=false;
    }
    else if(typeSelectorClicked==false)
    {
       slider.slideOut();
       typeSelectorClicked=true;
    }
   
    
  });

  document.getElementById("music").addEventListener("click",function()
  {
   
    document.getElementById("playList").innerHTML ="";
    currentPlayType ="music";
    getfileFromSDCard("music");
    changeOrientaton("music");

     document.getElementById("audioPlayer").style.display="none";
     var audioPlaySelect = document.getElementById("audioPlayerContainer");
     audioPlaySelect.style.display="none";
     document.getElementById("audioPlayer").pause();

  });

  document.getElementById("movies").addEventListener("click",function()
  {
    
    document.getElementById("playList").innerHTML ="";
    currentPlayType ="movies";
    getfileFromSDCard("movies");
    changeOrientaton("music");
  
  
  });
  
  document.getElementById("radio").addEventListener("click",function()
  {
    alert("Radio Under Construction");

  });




  getfileFromSDCard("music");
  changeOrientaton("music");
 
  document.getElementById("play").addEventListener("click",function()
  {
      if(togglePlay==false)
    {
    	document.getElementById("play").innerHTML ="Pause";
    	togglePlay=true;
    	document.getElementById("audioPlayer").play();
    	  isAudioPlaying=true;
    } else if(togglePlay==true)
    {
    	document.getElementById("play").innerHTML ="Play";
    	document.getElementById("audioPlayer").pause();
    	isAudioPlaying=false;
    	togglePlay=false;
    }
  

  });

  //Add Event Lisnter For Next
  document.getElementById("next").addEventListener("click",function()
  {
     var pos = filePointer();
     if(pos!=null)
     {
         if(pos>=0 && pos<=totalSongsFileName.length)
         {

          var currPos = pos+1;
          var getFile = totalSongs[currPos];
          playSelection(getFile);
          getCurrentTime(getFile);
          updateCurrentPlaying(getFile);

         }


     }


  });
   document.getElementById("previous").addEventListener("click",function()
  {
     
     var pos = filePointer();
     if(pos!=null)
     {
         if(pos>=0 && pos<=totalSongsFileName.length)
         {
          var currPos = pos-1;
          var getFile = totalSongs[currPos];
          playSelection(getFile);
           getCurrentTime(getFile);
           updateCurrentPlaying(getFile);

         }


     }

  });

   document.getElementById("seekLeft").addEventListener("mousedown",function()
  {
  
    var audioPlayer = document.getElementById("audioPlayer");
    if(isAudioPlaying==true )
    {	
       audioPlayer.currentTime = audioPlayer.currentTime- 30;
    }

  });
 
  document.getElementById("seekRight").addEventListener("mousedown",function()
  { 

    var audioPlayer = document.getElementById("audioPlayer");
     if(isAudioPlaying==true)
    {	
    audioPlayer.currentTime = audioPlayer.currentTime+30;
    }
  });
 
 document.getElementById("audioPlayerContainer").addEventListener("click",function()
 { 
   document.getElementById("audioPlayer").pause();

    document.getElementById("audioPlayerContainer").style.display="none";

 });

  document.getElementById("audioPlayer").addEventListener("click",function()
 {
     document.getElementById("audioPlayer").pause();
   
     document.getElementById("audioPlayer").style.display="none";

 })



function filePointer()
{
    var pointer = document.getElementById("selectedSongHolder").innerHTML;
    var i=0;
    var len = totalSongsFileName.length;
    matchPos =null;
    while(i!=len)
    {

      if(totalSongsFileName[i].toString()==pointer.toString())
      {
      	matchPos = i;
      }
      
     i+=1;
    }

    return matchPos;

 
}


  



}


function mycallback() 
{       
  alert("All tags in this file: " + ID3.getAllTags(file).toSource());
  alert("Title: " + ID3.getTag(file, "title") + " by artist: " + ID3.getTag(file, "artist"));
} 



function getfileFromSDCard(typeMedia)
{
    try
    {

    if(typeMedia=="music")
    {  
    var files = navigator.getDeviceStorage("music");
		var cursor = files.enumerate();
    var i =0;
	   cursor.onsuccess = function() 
		 {
			//alert("Got something");
			if(this.result)
			{	
			  var file = this.result;
			  gatherMediaID(file);
			  totalSongs[totalSongsCounter]= file;
			  totalSongsFileName[totalSongsCounter] = file.name.split(".mp3");

			  totalSongsCounter+=1;
        createPlayList(file);
			  this.continue();
			 }  
			  
		  }
     }

     if(typeMedia=="movies")
    {  
      var files = navigator.getDeviceStorage("videos");
      var cursor = files.enumerate();
      var i =0;
      cursor.onsuccess = function() 
      {
        //alert("Got something");
        if(this.result)
        { 
          var file = this.result;
          gatherMediaID(file);
          totalSongs[totalSongsCounter]= file;
          totalSongsFileName[totalSongsCounter] = file.name.split(".mp4");

          totalSongsCounter+=1;
          createPlayList(file);
          this.continue();
         }  
        
      }
     }
     

    if(typeMedia=="radio")
    {  
      
    
    }
     

   
		    //Get FM


/*var frequency = 99.1;
var radio = navigator.mozFMRadio;

if (radio.antennaAvailable)
 {
  radio.enable(frequency);
} else 
{
  alert("You need to plug your headphone");
}

radio.addEventListener('antennaavailablechange', function () 
{
  if (radio.antennaAvailable) 
  {
    radio.enable(frequency);
  } else 
  {
    radio.disable();
  }
});*/









    }
	catch(e)
	{
		alert(e);
	}
}



function createPlayList(file)
{
  

  if(currentPlayType=="music")
 {   



  var play = document.createElement("div");
  play.className = "playListSongContainer";
  var split2 = file.name.split(".mp3");
  play.innerHTML =  split2;
  play.id=counterSong;

  document.getElementById("playList").appendChild(play);
  
  document.getElementById(counterSong).addEventListener("click",function()
  {
     document.getElementById("audioPlayer").style.display="none";
 var audioPlaySelect = document.getElementById("audioPlayerContainer");
  audioPlaySelect.style.display="none";   
 

     currentSongPlayingById = counterSong;
    if(togglePlay==false)
    {
    	document.getElementById("play").innerHTML ="Pause";
    	togglePlay=true;
    	document.getElementById("audioPlayer").play();
    } /*else if(togglePlay==true)
    {
    	document.getElementById("play").innerHTML ="Play";
    	document.getElementById("audioPlayer").pause();
    	togglePlay=false;
    }*/



  	updateCurrentPlaying(file);
     getCurrentTime(file);
     playSelection(file);
    
     


  });
 
  counterSong+=1;


}
if(currentPlayType=="movies")
{
  
  

  var play = document.createElement("div");
  play.className = "playListSongContainer";
  var split2 = file.name.split(".mp4");
  play.innerHTML =  split2;
  play.id=counterSong;
 
 

  document.getElementById("playList").appendChild(play);
  
  document.getElementById(counterSong).addEventListener("click",function()
  {
    
   document.getElementById("audioPlayer").style.display="block";
  var audioPlaySelect = document.getElementById("audioPlayerContainer");
  audioPlaySelect.style.display="block";

    currentSongPlayingById = counterSong;
    if(togglePlay==false)
    {
      document.getElementById("play").innerHTML ="Pause";
      togglePlay=true;
      document.getElementById("audioPlayer").play();

    
     

    } /*else if(togglePlay==true)
    {
      document.getElementById("play").innerHTML ="Play";
      document.getElementById("audioPlayer").pause();
      togglePlay=false;
    }*/



    updateCurrentPlaying(file);
     getCurrentTime(file);
     playSelection(file);
    
     


  });
 
  counterSong+=1;





}



}

function updateCurrentPlaying(file)
{
     var split;
    if(currentPlayType=="music")
    {  
    split = file.name.split(".mp3");
    }
    if(currentPlayType=="movies")
    {  
    split = file.name.split(".mp4");
    }


  	document.getElementById("selectedSongHolder").innerHTML = split; 

}

function getCurrentTime(selectedSong)
{
    console.log(selectedSong.name);
    var audioPlayer = document.getElementById("audioPlayer");
    window.setInterval(function()
    {
      	document.getElementById("currentTime").innerHTML = Math.floor(audioPlayer.currentTime/60) +":"+Math.floor(audioPlayer.currentTime%60) +"/"+  Math.floor(audioPlayer.duration/60)+":"+Math.floor(audioPlayer.duration%60); 

    },1);  
}


function playSelection(selectedSong)
{

	 console.log(selectedSong.name);
     var audioPlayer = document.getElementById("audioPlayer");
     audioPlayer.src = window.URL.createObjectURL(selectedSong);
     audioPlayer.play();
     isAudioPlaying=true;

      //get Next File To Play
      var nextFileToPlay;
      var currFileName
    if(currentPlayType=="music")
    { 

       currFileName = selectedSong.name.split(".mp3");
    }

    if(currentPlayType=="movies")
    { 

       currFileName = selectedSong.name.split(".mp4");
    }
      var j=0;
      while(j!=totalSongsFileName.length)
      {
         if(currFileName.toString()==totalSongsFileName[j].toString())
         {
         
         	nextFileToPlay = totalSongs[j+1];


         }
        j+=1;
      }

    
       audioPlayer.addEventListener("ended",function()
      { 
       
       audioPlayer.src = window.URL.createObjectURL(nextFileToPlay);
       audioPlayer.play();
       updateCurrentPlaying(nextFileToPlay);
       getCurrentTime(nextFileToPlay);
      });

}




function gatherMediaID(file)
{
 
      url =  file.name;
      ID3.loadTags(url, function()
       {
        showTags(url);
        alert(url);
      }, 
      {
        tags: ["title","artist","album","picture"],
        dataReader: FileAPIReader(file)
      });

}



//implemet Search Pattern using seekSlider

