"use strict";
(function () {
  //Seta o contexto de audio
  var context = new window.AudioContext();

  //Função para setar o som de cada 'tecla'
  function setSom(id, freq){        
    document.getElementById(id).addEventListener("mousedown", function(){
      try {
        var oscilator = context.createOscillator();
        oscilator.connect(context.destination);
        oscilator.start(0);
        oscilator.frequency.value = freq;
        oscilator.stop(context.currentTime + 0.4);
      } catch(e){
        //just pass
      }
    });
  };

  //Setando o som de cada 'tecla'
  setSom("do", 264);
  setSom("re", 297);
  setSom("mi", 330);
  setSom("fa", 352);
  setSom("sol", 396);
  setSom("la", 440);
  setSom("si", 495);
  setSom("do2", 528);
})();
