document.getElementById('about').style.display = 'none';

function show(element){

	document.getElementById('about').style.display = 'none';
	document.getElementById('main').style.display = 'none';

	if (element=='main'){

		document.getElementById('main').style.display = 'block';

	}else{
		
		document.getElementById('about').style.display = 'block';
	}
}
function assign(){
	id = this.id.replace('Input','');
	if (id == "tempo")
		tempo = this.value;
	if (id == "beats")
		beats = this.value;
	if (id == "meter")
		meter = this.value;
}
function loadTickSound(url){
	var req = new XMLHttpRequest();
	req.open('GET',url,true);
	req.responseType = 'arraybuffer';

	req.onload = function() {
    	audioCtx.decodeAudioData(req.response, function(buffer) {
      		tick = buffer;
    	});
  	}
  	req.send();
}
function playTick(time,beat){
		if(play){
			source = audioCtx.createBufferSource();
			source.buffer = tick;
			var gainNodeBis = audioCtx.createGain();
			source.connect(gainNodeBis);
			gainNodeBis.connect(gainNode);
			source.onended = function(){
				playTime(startTime);
				document.querySelector("#beatShow").innerHTML = "<h2>" + (beat+1) + "</h2";
			}
			if(!source.start)
				source.start = source.noteOn;
			if (beat == 0)
				gainNodeBis.gain.value = 0.7;
			else
				gainNodeBis.gain.value = 0.3;
			source.start(time);
		}
}
//Program part

//VAR DECLARATION
var play = false;
var tempoInput = document.getElementById('tempoInput');
var barsInput = document.getElementById('barsInput');
var beatsInput = document.getElementById('beatsInput');
var meterInput = document.getElementById('meterInput');
var startButtom = document.getElementById('startButton');
var volumeRange = document.getElementById('volumeRange');

var startTime = 0;
var tempo = tempoInput.value;
var beats = beatsInput.value;
var meter = meterInput.value;
var beat = 0;
var bar = 0;
var volume = 0.7;

var audioCtx = new AudioContext;
var tick = loadTickSound('tick.ogg');
var gainNode = audioCtx.createGain();

//Audio connexions

gainNode.connect(audioCtx.destination);

//Events Listeners

tempoInput.addEventListener('change',assign,false);
beatsInput.addEventListener('change',assign,false);
meterInput.addEventListener('change',assign,false);
volumeRange.addEventListener('change',function(){
	volume = this.value / 100 + 0.5;
	gainNode.gain.value = volume;
},false);
startButton.addEventListener('click',function(){
	if (this.value == 'Start'){
		play = true;
		beat = 0;
		bar = 0;
		main();
		this.value = 'Stop';
	}else{
		play = false;
		this.value = 'Start';
	}
},false);

//App start

gainNode.gain.value = volume;

function main(){
	startTime = audioCtx.currentTime + 0.1;
	document.querySelector("#beatsShow").innerHTML = meter;
	playTime(startTime);
}

function playTime(startTime){
	time = startTime + ((beat+(bar*beats))*(60/tempo))*(4/meter);
	playTick(time,beat);
	if(beat==beats-1){
		bar++;
		beat = 0;
	}else{
		beat++;
	}
}