var url ="http://lvbp.meridiano.com.ve/ws/stats_json.aspx?metodo=Calendar&seasonId=29";

console.log("url: "+url);

request = new XMLHttpRequest({ mozSystem: true });
request.open('get', url, true);
request.responseType = 'json';
request.addEventListener('error', ErrorCargandoCalendario);
request.addEventListener('load', exitoCargandoCalendario);
request.send();

window.onload = function()
{
    document.getElementById("contadorPopUpPublicidad").addEventListener   ("click", function(){ cerrarPublicidad();}, false);
    document.getElementById("publicidad").addEventListener   ("click", function(){ mostrarPublicidad("http://dualvisio-estatico.azurewebsites.net/publicidad/calendario-tlf/");}, false);  
}

  function cerrarPublicidad()
  {
    document.getElementById("popUpPublicidad").classList.add('escondido');
  }

  function mostrarPublicidad(URL)
  {
    document.getElementById("popUpPublicidad").classList.remove('escondido');
    document.getElementById("resultadoPublicidad").src=URL;
  } 

function log(S)
{
  console.log(S);
}

function ErrorCargandoCalendario()
{
  
}

function exitoCargandoCalendario()
{
  var resultados = document.getElementById("resultados");
  
  var fechaReferencia = "";
  
  var partidos = request.response;
  
  var fondoTabla = "#000000";
  
  partidos.forEach(
    function(partido)
    {
      var startDate = partido.StartDate;
      
      var fecha = startDate.substr(0,startDate.indexOf(' '));
      var diaPartido = fecha.substr(0,2);
      var mesPartido = fecha.substr(3,2);
      var anoPartido = fecha.substr(6,4);
      fecha=anoPartido+"-"+mesPartido+"-"+diaPartido;
      var today = new Date().toJSON().slice(0,10);
      
      var d = new Date(fecha);
      var hoy = new Date();
      
      console.log("Hoy es " +hoy+" y el dia del partido es "+fecha);
      
      if(d>hoy)
      {
        var escudo1;
        var escudo2;
                
        
        if(partido.IdTeam1<10)
        {
          escudo1 = "http://wap.meridiano.com.ve/escudos/"+partido.IdTeam1+".gif";
          escudo2 = "http://wap.meridiano.com.ve/escudos/"+partido.IdTeam2+".gif";          
        }
        else
        {
             escudo1="";
             if(partido.IdTeam1==20){escudo1="../img/Cuba.png";}
             if(partido.IdTeam1==21){escudo1="../img/RepublicaDominicana.png";}
             if(partido.IdTeam1==26){escudo1="../img/Mexico.png";}
             if(partido.IdTeam1==27){escudo1="../img/PuertoRico.png";}
             if(partido.IdTeam1==30){escudo1="../img/Venezuela.png";}         
             
             escudo2="";
             if(partido.IdTeam2==20){escudo2="../img/Cuba.png";}
             if(partido.IdTeam2==21){escudo2="../img/RepublicaDominicana.png";}
             if(partido.IdTeam2==26){escudo2="../img/Mexico.png";}
             if(partido.IdTeam2==27){escudo2="../img/PuertoRico.png";}
             if(partido.IdTeam2==30){escudo2="../img/Venezuela.png";}         

        }

        var par2 = '<table style="background: '+fondoTabla+';">'+
                    '<tr>'+
                      '<th rowspan="2" ><img src="'+escudo1+'"></th>'+
                      '<th>'+partido.NameTeam1+'</th>'+
                      '<th>'+partido.NameTeam2+'</th>'+
                      '<th rowspan="2"><img src="'+escudo2+'"></th>'+
                    '</tr>'+
                    '<tr>'+
                      '<td colspan="2">'+partido.City+' - 7:30pm </td>'+
                    '</tr>'+
                  '</table>';
        
                var par = '<table style="background: '+fondoTabla+'; width: 100%;">'+
                    '<tr>'+
                      '<th rowspan="2" style=""><img src="'+escudo1+'"></th>'+
                      '<th>'+partido.NameTeam1+'</th>'+
                      '<th>'+partido.NameTeam2+'</th>'+
                      '<th rowspan="2" style=""><img src="'+escudo2+'"></th>'+
                    '</tr>'+
                    '<tr>'+
                      '<td colspan="2" style="font-size: small;" >'+partido.City+' - 7:30pm </td>'+
                    '</tr>'+
                  '</table>';

        if(fechaReferencia==fecha)
        {
           resultados.innerHTML +=par;          
        }
        else
        {
          var dia = d.getDay();
          var diaSemana = "";
          if(dia==0)
          {
            diaSemana="Lunes";
          }
          if(dia==1)
          {
            diaSemana="Martes";
          }
          if(dia==2)
          {
            diaSemana="Miercoles";
          }
          if(dia==3)
          {
            diaSemana="Jueves";
          }
          if(dia==4)
          {
            diaSemana="Viernes";
          }
          if(dia==5)
          {
            diaSemana="Sabado";
          }
          if(dia==6)
          {
            diaSemana="Domingo";
          }
          
          resultados.innerHTML +="<p> "+diaSemana+" - "+fecha+" </p>"; 
          resultados.innerHTML +=par;        
          fechaReferencia = fecha;
        }
      }
              
    });
  
}
