'use strict';

// Run Ctrl
app.controller('RunCtrl', function($scope, $timeout, $rootScope, $interval, Exercice, Share, Settings) {


		// Generating
		$scope.generating = true;
		$scope.running    = false;
		$scope.finish     = false;
		$scope.stop       = false;
		$scope.action     = false;

		// Program
		$scope.program = Share.getProgram();
		// Title
		$scope.title = $scope.program.title;


		// Timer info
		$scope.timer = { "break":"", "duration":"" };
		$scope.current;
		$scope.next;
		$scope.image = "";

		// Lock if config tells it : lock the screen while running
		// This var contains the lock
		var lockScreen = null;
		// Orientation lock
		var lockOrientation = null;
		
		// When changing page : reset the timer and some others things
		$rootScope.$on("$routeChangeStart", 
						function(event, current, previous, rejection) { 
							// Stop the counting
							$scope.break();
							// Un lock
							if(lockScreen) { lockScreen.unlock(); lockScreen = null; }
					  }); // /rootScope.$on

		// Exercice loading : at the present time
		Exercice.load($scope.program).then(function(data) {
				// sort the list and store the list
			    $scope.list = data
					.filter(function(e) { return e.active == 1; })
				    .sort(function(a,b) { return parseInt(a.order) > parseInt(b.order); });
				
				// the first one
				$scope.currentIndex = 0;
				$scope.maxIndex = $scope.list.length;

				// People love waiting !
		        $timeout(function() { 
						// changing screen
						$scope.running = true;
						$scope.generating = false; 
						// Lock screen ?
						if(Settings.lockScreen() == 1) {
								if(window.navigator.requestWakeLock) {
								      lockScreen = window.navigator.requestWakeLock("screen");
								}
						}
						// Play
						$scope.play();
				}, 2000);
		});

		// Start
		$scope.play = function() {
			//console.log("PLAY");
			if(! angular.isDefined($scope.interval)) {
				$scope.interval = $interval(function() {
                      $scope.step();
				}, 1000);
			}
			 //console.log($scope.stop);
			 $scope.stop = false;
			 // Reset image if duration > 0
			 if($scope.timer.duration > 0) {
			    $scope.image = $scope.current.image;
			 }
			 //console.log($scope.stop);
		}; // /start


		// Step
		$scope.step = function() {
			 //console.log($scope.stop);
		    // No current
			if((!angular.isDefined($scope.current)) && ($scope.currentIndex < $scope.list.length) ) {
				$scope.setCurrent();
			}

			// Depending
			if($scope.timer.break > 0) {
				//$scope.action = false;
                $scope.timer.break--;
				$scope.image = $scope.current.image;
			    if($scope.timer.break == 0) {
				    $scope.action = true;
					$scope.notifyUser(0);
				}	
			}
			else if($scope.timer.duration > 0) {
				//$scope.action = true;
                $scope.timer.duration--;
				$scope.image = $scope.current.image;
			    if($scope.timer.duration == 0) {
					$scope.notifyUser(1);
				}	
			} else if($scope.currentIndex < $scope.list.length) {
					$scope.currentIndex++;
					$scope.setCurrent();
			} else {
					$scope.break();
					$scope.finish = true;
					$scope.running = false;
					$scope.notifyUser(2);
			}

		}; // /step

		// Sound Var
		var goAudio = new Audio('/data/sounds/go.ogg');
		goAudio.mozAudioChannel = 'notification';
		var breakAudio = new Audio('/data/sounds/break.ogg');
		breakAudio.mozAudioChannel = 'notification';
		var finalAudio = new Audio('/data/sounds/final.ogg');
		finalAudio.mozAudioChannel = 'notification';

		// Notify user
		$scope.notifyUser = function(type) {
				// Vibration ?
			    if(Settings.vibrationActivated()==1) {
					  //console.log('Vibrate');
                      navigator.vibrate(Settings.vibrationDuration());
				}

				// Sound ?
				if(Settings.soundActivated()==1) {
					  //console.log('Sound');
					  if(type==0) { goAudio.play(); }
					  else if(type==1) { breakAudio.play(); }
					  else { finalAudio.play(); }
				} // Send

		} // /notifyUser

		// Set the current maybe and also the next if exist
		$scope.setCurrent = function() {
			// The current
			if($scope.currentIndex < $scope.list.length) {
			   $scope.current = $scope.list[$scope.currentIndex];
			   if(angular.isDefined($scope.current)) {
				   // Beginning by a break ;)
				   $scope.action = false;
		           $scope.timer.duration = $scope.current.duration;
		           $scope.timer.break = $scope.current.break;
				   $scope.image = $scope.current.image;
			   }
			} // /current

		}; // /setCurrent

		// Stop
		$scope.break = function() {
			//console.log("STOP !");
             if(angular.isDefined($scope.interval)) {
                  $interval.cancel($scope.interval);
				  $scope.interval = undefined;
			 }
			 $scope.stop = true;
			 $scope.image = false;
		}; // stop

		// Next
		$scope.goNext = function() {
			if($scope.currentIndex < $scope.maxIndex -1) {
			    $scope.currentIndex++;
			    $scope.setCurrent();
			}
		}; // next

		// Previous
		$scope.goPrevious = function() {
			if($scope.currentIndex > 0) {
			    $scope.currentIndex--;
			    $scope.setCurrent();
			}
		}; // next

}); // RunCtrl
