// ----- Configuracion inicial ----- //

// Declarar aplicacion angular:
var app = angular.module('myApp', ["ngRoute", "mobile-angular-ui",]);
        
// Definir rutas.
app.config(function($routeProvider) {
    $routeProvider
        .when('/', {
            controller: 'IntroController',
            templateUrl: 'views/intro.html'
        })
        .when('/edad', {
            controller: 'EdadController',
            templateUrl: 'views/textoAndBotones.html'
        })
        .when('/altura', {
            controller: 'AlturaController',
            templateUrl: 'views/textoAndBotones.html'
        })
        .when('/contextura', {
            controller: 'ContexturaController',
            templateUrl: 'views/textoAndBotones.html'
        })
        .when('/pasatiempos', {
            controller: 'PasatiemposController',
            templateUrl: 'views/textoAndBotones.html'
        })
        .when('/respuesta', {
            controller: 'RespuestaController',
            templateUrl: 'views/respuesta.html'
        })
        .when('/idioma', {
            controller: 'IdiomaController',
            templateUrl: 'views/idioma.html'
        })
    ;
});



// ----- Variables y funciones compartidas ----- //

function respuestaToString(resp) {
    var str = shared.text("DebesOptarPorUnEstilo");
 
    var estilos = [];   
    for (var key in resp.value) {
        estilos.push(key);
    }
    for(var i=0; i<estilos.length; i++) {
        if(i > 0 && i < estilos.length -1) str +=","
        if(i > 0 && i == estilos.length -1) str +=" " + shared.text("y");
        str += " " + shared.text(estilos[i]);
    }
    str += ".";
    
    if(resp.comment != null && resp.comment[shared.lang] != null) {
        str += " " + resp.comment[shared.lang] + ".";
    }
    
    return str;
}

var shared = {
    res: {},
    lang: "en",
    text: function(key) { return textos[key] != null? textos[key][shared.lang] : key; }
};



// ----- Controladores ----- //

app.controller('NavbarController', function ($scope, $location) {
    // Obtener idioma (por defecto ingles).
    var lang = amplify.store("lang");
    if(lang !== "es" && lang !== "fr" && lang !== "en") lang = "en";
    shared.lang = lang;
 
    // Inicializar campos.   
    $scope.cabecera = shared.text("TituloNavbar");
    $scope.pie = shared.text("CambiarIdioma");
    $scope.showFooter = $location.path() === '/';
 
    // Solo mostrar footer al inicio y actualizar el idioma de los textos en la pantalla de inicio.
    $scope.$on('$routeChangeStart', function(next, current) { 
        if($location.path() === '/') {
            $scope.cabecera = shared.text("TituloNavbar");
            $scope.pie = shared.text("CambiarIdioma");
            $scope.showFooter = true;
        } else {
            $scope.showFooter = false;
        }
    });
});


app.controller('IdiomaController', function ($scope, $location) {
    // Obtener idioma actual.
    var lang = amplify.store("lang");
    if(lang !== "es" && lang !== "fr" && lang !== "en") lang = "en";

    // Definir texto y opciones.
    $scope.texto = textos["EligeTuIdioma"][lang];
    $scope.opciones = [
        {key: 'en', value: "English"},
        {key: 'es', value: "Español"},
        {key: 'fr', value: "Français"}
    ];

    $scope.siguiente = function(key) {
        // Guardar idioma y volver al inicio.
        amplify.store("lang", key);
        shared.lang = key;
        $location.path("/");
    };
});

app.controller('IntroController', function ($scope, $location) {
    // Verificar si el usuario ya eligio su idioma.
    if(amplify.store("lang") == null) {
        // Abrir pantalla para elegir el idioma.
        $location.path("/idioma");
    } else {
        // Proceder normalmente.
        //$scope.texto = shared.text("DescubreTuEstiloConSainap");
        $scope.pregunta = shared.text("QueEdadTienes");
        $scope.boton = shared.text("HazClick");
        
        $scope.siguiente = function() {
            shared.res = {};
            $location.path("/edad");
        };
    }
});

app.controller('EdadController', function ($scope, $location) {
    //$scope.texto = shared.text("QueEdadTienes");
    $scope.texto = '';
    
    $scope.opciones = [
        {key: 'a01', value: "11-13"},
        {key: 'a01', value: "14-16"},
        {key: 'a03', value: "17-19"},
        {key: 'a03', value: "20-22"},
        {key: 'a03', value: "23-25"},
        {key: 'a06', value: "26-29"},
        {key: 'a06', value: "30-35"},
        {key: 'a08', value: "36-40"},
        {key: 'a08', value: "41-45"},
        {key: 'a10', value: "46-50"},
        {key: 'a10', value: "51-55"},
        {key: 'a12', value: "56-60"},
        {key: 'a12', value: "61-65"},
        {key: 'a12', value: "66-70"},
        {key: 'a15', value: "71-80"},
        {key: 'a15', value: "81-90"},
        {key: 'a15', value: shared.text("91oMas")}
    ];

    $scope.siguiente = function(key) {
        shared.res['e'] = key;
        $location.path("/altura");
    };
});

app.controller('AlturaController', function ($scope, $location) {
    $scope.texto = shared.text("TuEres") + ":";
    
    $scope.opciones = [
        {key: 'b1', value: shared.text("Alta")},
        {key: 'b2', value: shared.text("Baja")},
        {key: 'b3', value: shared.text("Media")}
    ];

    $scope.siguiente = function(key) {
        shared.res['a'] = key;
        $location.path("/contextura");
    };
});

app.controller('ContexturaController', function ($scope, $location) {
    $scope.texto = shared.text("TuConsiderasQueEres") + ":";
    
    $scope.opciones = [
        {key: 'c1', value: shared.text("Delgada")},
        {key: 'c2', value: shared.text("Corpulenta")},
        {key: 'c3', value: shared.text("Equilibrada")}
    ];

    $scope.siguiente = function(key) {
        shared.res['c'] = key;
        $location.path("/pasatiempos");
    };
});

app.controller('PasatiemposController', function ($scope, $location) {
    $scope.texto = shared.text("QueActividadPrefieres");
    
    $scope.opciones = [
        {key: 'd1', value: shared.text("Deportes")},
        {key: 'd2', value: shared.text("MusicaYArte")},
        {key: 'd3', value: shared.text("PasatiemposQueNoExijan")}
    ];

    $scope.siguiente = function(key) {
        shared.res['p'] = key;
        $location.path("/respuesta");
    };
});

app.controller('RespuestaController', function ($scope, $location) {
    try {
        $scope.texto = respuestaToString(resultados[
            shared.res['e'] + "-" +
            shared.res['a'] + "-" +
            shared.res['c'] + "-" +
            shared.res['p']
        ]);
        $scope.imagen = "img/resultado.png";
        $scope.boton = shared.text("VolverAEmpezar");
        
        $scope.siguiente = function(key) {
            $location.path("/");
        };
    }catch(ex) {
        // Si ocurre un error (normalmente porque se recargo la pagina en una vista que no sea ni la de inicio ni la de idioma), volver al inicio.
        console.log(ex);
        $location.path("/");
    }
});
