(function(root, factory){
	'use strict';
	
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['jquery', 'devbridgeAutocomplete'], factory);
    } else if (typeof exports === 'object' && typeof require === 'function') {
        // Browserify
        root.Autocomplete = factory(jQuery, require('devbridgeAutocomplete'));
    } else {
        // Browser globals
        root.Autocomplete = factory(jQuery, jQuery.fn.autocomplete);
    }
    
})(this, function($, autocomplete){
	var AutocompleteSingleton = (function(){
		var _instance = false;
		
		function Autocomplete(){
			var _self = this;
			var _started = false;
			var _options = {
				// appendTo: '#search-suggests',
				// appendTo: getAppendTo(),
				serviceUrl: Routing.generate('searcher_search_suggest', {}, true),
				type: 'POST',
				dataType: 'json',
				params: {
					length: 5
				},
				minChars: 3,
				maxHeight: 300,
				deferRequestBy: 300,
				// delimiter: ', ',
				delimiter: '/,\s*/ig',
				// delimiter: new RegExp(',\s*', 'ig'),
				triggerSelectOnValidInput: false,
				onSelect: function(suggestion) {
					_self.$el.trigger('change');
					// console.log('You selected: ' + suggestion.value);
		        },
				showNoSuggestionNotice: true,
				noSuggestionNotice: 'Aucune suggestion'
				// onInvalidateSelection: function(){},
				// forceFixPosition: true
			};
			
			this.$el = $('#search_form_expression');
			
			this.isStarted = function(){
				return _started;
			};
			
			this.getElName = function(){
				return '#search_form_expression';
			};
			
			this.getAppendTo = function(){
				return '#search-suggests';
			};
			
			this.start = function(){
				if (this.$el.length > 0 && this.isStarted() === false) {
					console.log('Autocomplete started.');
					this.$el.autocomplete(_options);
					_started = true;
				}
			};
			
			this.stop = function(){
				if (this.$el.length > 0 && this.isStarted() === true) {
					console.log('Autocomplete stopped.');
					this.$el.autocomplete('dispose');
					_started = false;
				}
			};
			
			this.enable = function(){
				if (this.$el.length > 0 && this.isStarted()) {
					this.$el.autocomplete('enable');
					console.log('Autocomplete enabled.');
				}
			};
			
			this.disable = function(){
				if (this.$el.length > 0 && this.isStarted()) {
					this.$el.autocomplete('disable');
					console.log('Autocomplete disabled.');
				}
			};
			
			this.hide = function() {
				if (this.$el.length > 0 && this.isStarted()) {
					this.$el.autocomplete('hide');
//					$('.autocomplete-suggestions').hide();
				}
			};
		};
		
		return {
			getInstance: function(){
				if (!_instance) {
					_instance = new Autocomplete();
					console.log('Autocomplete Singleton instance create.');
				}
				return _instance;
			}
		};
	})();
	
	return AutocompleteSingleton.getInstance();
});