(function(root, factory){
	'use strict';
	
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['jquery'], factory);
    } else if (typeof exports === 'object' && typeof require === 'function') {
        // Browserify
        root.Autocomplete = factory(jQuery);
    } else {
        // Browser globals
        root.Autocomplete = factory(jQuery);
    }
    
})(this, function($){
	var canvasoff = (function(){
		var $canvasType = $(".canvas-off-left"),
			$canvasActiviated = false;

		/**
		 * Function to open canvas Type
		 * @param  String canvasType [left|right|top|bottom]
		 */
		function openCanvas(canvasType){
	        selectCanvasType(canvasType);
	        $canvasType.addClass('canvas-off-open');
	        $('.canvas-off-overlay').addClass('canvas-off-open');
		}

		/**
		 * Function to close canvas Type
		 * @param  String canvasType [left|right|top|bottom]
		 */
		function closeCanvas(canvasType){
			selectCanvasType(canvasType);
	        $canvasType.removeClass('canvas-off-open');
	        $('.canvas-off-overlay').removeClass('canvas-off-open');
		}

		/**
		 * Function to open or close canvas Type
		 * @param  String canvasType [left|right|top|bottom]
		 */
		function toggleCanvas(canvasType){
			//disable();
			selectCanvasType(canvasType);
			$canvasType.toggleClass('canvas-off-open');
			$(".canvas-off-overlay").toggleClass('canvas-off-open');
		}

		function disable(param){
			if (!param) {
				$('.canvas-off').each(function(){
					$(this).removeClass(".canvas-off-open");
				});
			}
		}
		
		function selectCanvasType(canvasType){
			switch( canvasType ) {
				case "left":
					$canvasType = $(".canvas-off-left");
					break;
				case "right":
					$canvasType = $(".canvas-off-right");
					break;
				case "top":
					$canvasType = $(".canvas-off-top");
					break;
				case "bottom":
					$canvasType = $(".canvas-off-bottom");
					break;
				default:
	        		$canvasType = $(".canvas-off-left");
	        }
		}

	    return { 
			//init : init,
			openCanvas : openCanvas,
			closeCanvas : closeCanvas,
			toggleCanvas : toggleCanvas
		};
	})();
	
	return canvasoff;
});
