/**
 * Initialize default configuration global
 */
define(['offline', 'jquery', 'notification'], function(Offline, $, NotificationManager){
	'use strict';
	
	/**
	 * @var boolean
	 */
	var initialized = false;
	
	/**
	 * Define default settings for jQuery
	 */
	var initializejQuery = function(){
		$.ajaxPrefilter(function(options, originalOptions, jqXHR) {
			options.crossDomain = false;
			options.xhr = function(){
				return new window.XMLHttpRequest({mozSystem: true});
			};
		});
	};
	
	/**
	 * Initialize Offline checking
	 */
	var initializeOffline = function(){
		Offline.options = {
			checkOnLoad: true,
			checks: {
				xhr: {url: Routing.generate('searcher_search_refresh_session', {}, true)}
			},
			interceptRequests: true,
			reconnect: {
				initialDelay: 3,
//				delay: (5)
				delay: (1,5 * 10)
			},
			requests: true,
			game: false
		};
		
		var hidden, visibilityChange;
		if (typeof document.hidden !== "undefined") { // Opera 12.10 and Firefox 18 and later support
			hidden = "hidden";
			visibilityChange = "visibilitychange";
		} else if (typeof document.mozHidden !== "undefined") {
			hidden = "mozHidden";
			visibilityChange = "mozvisibilitychange";
		} else if (typeof document.msHidden !== "undefined") {
			hidden = "msHidden";
			visibilityChange = "msvisibilitychange";
		} else if (typeof document.webkitHidden !== "undefined") {
			hidden = "webkitHidden";
			visibilityChange = "webkitvisibilitychange";
		}
		
		var interval = [2, 3, 5];
		(function runner(){
			console.log('Internet connexion status is ' + Offline.state);
			if (Offline.state === 'up') {
				Offline.check();
			}
			
			if (document[hidden]) {
				++REFRESH_SESSION_HEARTBEAT_COUNT;
				if (REFRESH_SESSION_HEARTBEAT_COUNT >= 10) {
					var i = interval.pop();
					interval.push(i);
					REFRESH_SESSION_TIME *= i;
					REFRESH_SESSION_HEARTBEAT_COUNT = 0;
					if (REFRESH_SESSION_TIME > REFRESH_SESSION_TIME_MAX) {
						REFRESH_SESSION_TIME = REFRESH_SESSION_TIME_MIN;
					}
				}
			}
			
			setTimeout(function(){
				runner();
				console.log('Internet connexion checked, status is ' + Offline.state);
			}, REFRESH_SESSION_TIME);
		})();
		
		document.addEventListener(visibilityChange, function(){
			if (!document[hidden]) {
				REFRESH_SESSION_TIME = REFRESH_SESSION_TIME_MIN;
				REFRESH_SESSION_HEARTBEAT_COUNT = 0;
			}
		}, false);
	};
	
	var lockScreen = function() {
		if (window.screen.mozLockOrientation('portrait-primary')) {
			console.log('Orientation was locked');
		} else {
			console.log('Orientation lock failed');
		}
	};
	
	var initialize = function(){
		if (initialized === false) {
			initializeOffline();
			initializejQuery();
			
			// Boot loader NotificationManager
			if (!NotificationManager.isBooted) {
				NotificationManager.boot();
			}
			
			// Screen lock portrait-primary by default
			console.log('Screen orientation is ' + window.screen.mozOrientation);
			window.screen.mozOnorientationchange = function(){
				console.log('The orientation of the screen is: ' + screen.mozOrientation);
				lockScreen();
			};
			
			initialized = true;
		}
	};
	
	return {
		init: initialize,
		initjQuery: initializejQuery,
		initOffline: initializeOffline,
		isInitialized: function() {
			return initialized;
		}
	};
});