function initBlocks(game, matrix){
	var blocks = new Group();
	blocks.game = game;
	
	for(var i=0; i < matrix.length; i++){
		var row=matrix[i];
		
		//対象行のブロックのy位置を決定
		var y = i * (game.config.block.height
									+ game.config.block.margin.top
									+ game.config.block.margin.bottom)
									+ game.config.block.margin.top
									+ game.config.blocks.margin.top;
									
		//各行のブロックを作成して位置を決め、Groupに追加
		for(var j=0; j<row.length; j++){
			//ブロックを作成
			var block=createBlock(game, row[j]);
			
			//対象列のブロックのx位置を決定
			block.x = j * (game.config.block.width
										+ game.config.block.margin.left
										+ game.config.block.margin.right)
										+ game.config.block.margin.left 
										+ game.config.blocks.margin.left;
			block.y = y;
			blocks.addChild(block);
		}
	}
	return blocks;
}

function createBlock(game, type){
	var sprite = new Sprite(game.config.block.width, game.config.block.height);
	sprite.image=game.assets["img/block00.png"];
	sprite.type = type;
	return sprite;
}

function crashBlocks(blocks, ball){
	//blocksグループの各子ノードに対して実行
	blocks.childNodes.forEach(function(block){
		if(block.intersect(ball)){
			//ボールのdy値を反転させ、ボールを跳ね返らせる
			ball.dy = ball.dy * -1;
			blocks.removeChild(block);

			//blockCrashイベントオブジェクト作成
			var event = new Event(blocks.game.events.blockCrash);
			event.value = block.type;
			blocks.game.dispatchEvent(event);

			//全てのブロックを消去
			if(blocks.childNodes.length == 0){
				blocks.game.dispatchEvent(new Event(blocks.game.events.nextLevel));
			}
		}
	});
	return blocks;
}
