function initMain(game){
	console.log("ブロック崩しのシーンを初期化");
	
	var scene = new Scene(game.width, game.height);
	var blocks = null;
	var ball = initBall(game);
	var paddle = initPaddle(game);
	var countdown = createCountdownWidget(game);
	
	scene.addChild(paddle);
	scene.level = 0;
	start();
	
	function start(){
		if(blocks != null){
			scene.removeChild(blocks);
		}
		blocks = initBlocks(game, game.stages[scene.level]);
		countdown.age = 0;
		resetBall(ball, game);
		
		scene.addChild(blocks);
		scene.addChild(countdown);
		scene.removeChild(ball);
	}
	
	//カウントダウンアニメーション
	countdown.addEventListener(Event.ANIMATION_END, function(){
		console.log("ゲーム開始");
		scene.removeChild(countdown);
		scene.addChild(ball);
	});

	//パドル操作
	scene.addEventListener(Event.TOUCH_MOVE, function(event){
		var touchedPoint = {
			x: event.localX,
			y: event.localY
		};
		movePaddleTo(paddle, scene, touchedPoint);
	});

	//フレーム毎にボール状態を更新
	ball.addEventListener(Event.ENTER_FRAME, function(){
		ball.x = ball.x + ball.dx;
		ball.y = ball.y + ball.dy;
		reboundBallByWall(ball, scene);
		reboundBallByPaddle(ball, paddle);
		crashBlocks(blocks, ball);
		//ボールが落ちたらゲームオーバー
		if(ball.y > scene.height){
			game.dispatchEvent(new Event(game.events.gameOver));
		}
	});

	//ゲームのレベルを更新
	scene.addEventListener(game.events.nextLevel, function(event){
		scene.level++;
		start();
		if(game.stages[scene.level] != null){
			game.dispatchEvent(new Event(game.events.ready));
		}else{
			game.dispatchEvent(new Event(game.events.gameOver));
		}
	});

	//リスタート操作
	scene.addEventListener(game.events.restart, function(event){
		scene.level = 0;
		start();
		game.dispatchEvent(new Event(game.events.ready));
	});

	return scene;
}
