function initSplash(game){
	var scene = new Scene();
	scene.addChild(createSplashImage(game));
	scene.addEventListener("touchend", function(){
		var event = new Event(game.events.splashEnd);
		game.dispatchEvent(event);
	});
	return scene;
}

function createSplashImage(game){
	var image = game.assets["img/splash.png"];
	var sprite = new Sprite(image.width, image.height);

	//ʒɔzu
	sprite.x = (game.width - sprite.width) / 2;
	sprite.y = (game.height - sprite.height) / 2;

	sprite.image = image;
	return sprite;
}

function startSplash(game){
	if(game.scenes.splash == null){
		game.scnes.splash = initSplash(game);
	}
	game.pushScene(game.scenes.splash);
}
